/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.networking.message;

import com.mrbysco.forcecraft.container.ItemCardContainer;
import com.mrbysco.forcecraft.items.ItemCardItem;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class SaveCardRecipeMessage {
    public void encode(PacketBuffer buf) {
    }

    public static SaveCardRecipeMessage decode(PacketBuffer packetBuffer) {
        return new SaveCardRecipeMessage();
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide().isServer() && ctx.getSender() != null) {
                ServerPlayerEntity player = ctx.getSender();
                World world = player.field_70170_p;
                ItemStack stack = SaveCardRecipeMessage.getCardStack((PlayerEntity)player);
                if (!stack.func_190926_b() && player.field_71070_bA instanceof ItemCardContainer) {
                    ItemCardContainer itemCardContainer = (ItemCardContainer)player.field_71070_bA;
                    CraftingInventory craftMatrix = itemCardContainer.getCraftMatrix();
                    CraftResultInventory craftResult = itemCardContainer.getCraftResult();
                    Optional iRecipe = player.field_71133_b.func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)craftMatrix, world);
                    iRecipe.ifPresent(recipe -> {
                        CompoundNBT nbt = stack.func_196082_o();
                        CompoundNBT recipeContents = new CompoundNBT();
                        for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
                            recipeContents.func_218657_a("slot_" + i, (INBT)craftMatrix.func_70301_a(i).func_77955_b(new CompoundNBT()));
                        }
                        recipeContents.func_218657_a("result", (INBT)craftResult.func_70301_a(0).func_77955_b(new CompoundNBT()));
                        nbt.func_218657_a("RecipeContents", (INBT)recipeContents);
                        stack.func_77982_d(nbt);
                    });
                }
                player.func_145747_a((ITextComponent)new StringTextComponent("Recipe saved").func_240699_a_(TextFormatting.YELLOW), Util.field_240973_b_);
            }
        });
        ctx.setPacketHandled(true);
    }

    private static ItemStack getCardStack(PlayerEntity player) {
        if (player.func_184614_ca().func_77973_b() instanceof ItemCardItem) {
            return player.func_184614_ca();
        }
        if (player.func_184592_cb().func_77973_b() instanceof ItemCardItem) {
            return player.func_184592_cb();
        }
        return ItemStack.field_190927_a;
    }
}

