/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.networking.message;

import com.mrbysco.forcecraft.container.ItemCardContainer;
import com.mrbysco.forcecraft.items.ItemCardItem;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class RecipeToCardMessage {
    private List<ItemStack> stacks;

    public RecipeToCardMessage(List<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.stacks.size());
        for (ItemStack output : this.stacks) {
            buf.func_150788_a(output);
        }
    }

    public static RecipeToCardMessage decode(PacketBuffer packetBuffer) {
        int size = packetBuffer.readInt();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(size);
        for (int i = 0; i < size; ++i) {
            outputs.add(packetBuffer.func_150791_c());
        }
        return new RecipeToCardMessage(outputs);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerPlayerEntity player = ctx.getSender();
            ItemStack mainhand = ItemStack.field_190927_a;
            if (player.func_184614_ca().func_77973_b() instanceof ItemCardItem) {
                mainhand = player.func_184614_ca();
            } else if (player.func_184592_cb().func_77973_b() instanceof ItemCardItem) {
                mainhand = player.func_184592_cb();
            }
            if (!mainhand.func_190926_b() && mainhand.func_77973_b() == ForceRegistry.ITEM_CARD.get() && player.field_71070_bA instanceof ItemCardContainer) {
                ItemCardContainer itemCardContainer = (ItemCardContainer)player.field_71070_bA;
                itemCardContainer.setMatrixContents((PlayerEntity)player, this.stacks);
            }
        });
        ctx.setPacketHandled(true);
    }
}

