/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.networking.message;

import com.mrbysco.forcecraft.items.ForceBeltItem;
import com.mrbysco.forcecraft.util.FindingUtil;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;

public class QuickUseBeltMessage {
    public int slot;

    public QuickUseBeltMessage(int slot) {
        this.slot = slot;
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.slot);
    }

    public static QuickUseBeltMessage decode(PacketBuffer packetBuffer) {
        return new QuickUseBeltMessage(packetBuffer.readInt());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ItemStack beltStack;
            Predicate<ItemStack> stackPredicate;
            ServerPlayerEntity player;
            if (ctx.getDirection().getReceptionSide().isServer() && ctx.getSender() != null && FindingUtil.hasSingleStackInHotbar((PlayerEntity)(player = ctx.getSender()), stackPredicate = stack -> stack.func_77973_b() instanceof ForceBeltItem) && !(beltStack = FindingUtil.findInstanceStack((PlayerEntity)player, stackPredicate)).func_190926_b()) {
                beltStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                    ItemStack stack = handler.getStackInSlot(this.slot);
                    World world = player.field_70170_p;
                    if (!stack.func_190926_b()) {
                        stack.func_77950_b(world, (LivingEntity)player);
                        world.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), stack.func_226629_F_(), player.func_184176_by(), 0.5f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
                    }
                });
            }
        });
        ctx.setPacketHandled(true);
    }
}

