/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.networking.message;

import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.network.NetworkEvent;

public class PackChangeMessage {
    public Hand hand;
    public String customName;
    public int color;

    public PackChangeMessage(Hand hand, String customName, int color) {
        this.hand = hand;
        this.customName = customName;
        this.color = color;
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.hand == Hand.MAIN_HAND ? 0 : 1);
        buf.func_180714_a(this.customName);
        buf.writeInt(this.color);
    }

    public static PackChangeMessage decode(PacketBuffer packetBuffer) {
        return new PackChangeMessage(packetBuffer.readInt() == 0 ? Hand.MAIN_HAND : Hand.OFF_HAND, packetBuffer.func_150789_c(Short.MAX_VALUE), packetBuffer.readInt());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ItemStack stack;
            if (ctx.getDirection().getReceptionSide().isServer() && ctx.getSender() != null && ((stack = ctx.getSender().func_184586_b(this.hand)).func_77973_b() == ForceRegistry.FORCE_PACK.get() || stack.func_77973_b() == ForceRegistry.FORCE_BELT.get())) {
                CompoundNBT tag = stack.func_196082_o();
                tag.func_74768_a("Color", this.color);
                stack.func_77982_d(tag);
                if (this.customName.isEmpty()) {
                    stack.func_135074_t();
                } else if (!stack.func_200301_q().func_150261_e().equals(this.customName)) {
                    stack.func_200302_a((ITextComponent)new StringTextComponent(this.customName).func_240699_a_(TextFormatting.YELLOW));
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

