/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.networking.message;

import com.mrbysco.forcecraft.blocks.infuser.InfuserContainer;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.inventory.container.Container;
import net.minecraftforge.fml.network.NetworkEvent;

public class InfuserMessage {
    public boolean isButtonPressed;

    public InfuserMessage(boolean buttonPressed) {
        this.isButtonPressed = buttonPressed;
    }

    public void encode(ByteBuf buf) {
        buf.writeBoolean(this.isButtonPressed);
    }

    public static InfuserMessage decode(ByteBuf packetBuffer) {
        return new InfuserMessage(packetBuffer.readBoolean());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            Container container;
            if (ctx.getDirection().getReceptionSide().isServer() && ctx.getSender() != null && (container = ctx.getSender().field_71070_bA) instanceof InfuserContainer) {
                InfuserContainer ctr = (InfuserContainer)container;
                if (this.isButtonPressed) {
                    ctr.getTile().startWork();
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

