/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.mrbysco.forcecraft.capablilities.CapabilityHandler;
import com.mrbysco.forcecraft.capablilities.magnet.IMagnet;
import com.mrbysco.forcecraft.capablilities.magnet.MagnetProvider;
import com.mrbysco.forcecraft.capablilities.magnet.MagnetStorage;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.registry.ForceEffects;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;

public class MagnetGloveItem
extends BaseItem {
    public MagnetGloveItem(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (CapabilityHandler.CAPABILITY_MAGNET == null) {
            return null;
        }
        return new MagnetProvider();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (playerIn.func_225608_bj_()) {
            ItemStack stack = playerIn.func_184586_b(handIn);
            stack.getCapability(CapabilityHandler.CAPABILITY_MAGNET).ifPresent(cap -> {
                boolean state = cap.isActivated();
                cap.setActivation(!state);
                worldIn.func_184148_a((PlayerEntity)null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187909_gi, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            });
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        IMagnet magnetCap;
        if (entityIn instanceof PlayerEntity && !(entityIn instanceof FakePlayer) && itemSlot >= 0 && itemSlot <= PlayerInventory.func_70451_h() && (magnetCap = (IMagnet)stack.getCapability(CapabilityHandler.CAPABILITY_MAGNET).orElse(null)) != null && magnetCap.isActivated()) {
            ((PlayerEntity)entityIn).func_195064_c(new EffectInstance((Effect)ForceEffects.MAGNET.get(), 20, 1, true, false));
        }
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT nbt = super.getShareTag(stack);
        IMagnet cap = (IMagnet)stack.getCapability(CapabilityHandler.CAPABILITY_MAGNET).orElse(null);
        if (cap != null) {
            CompoundNBT shareTag = MagnetStorage.serializeNBT(cap);
            if (nbt == null) {
                nbt = new CompoundNBT();
            }
            nbt.func_218657_a("forcecraft", (INBT)shareTag);
        }
        return nbt;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (nbt == null || !nbt.func_74764_b("forcecraft")) {
            return;
        }
        IMagnet cap = (IMagnet)stack.getCapability(CapabilityHandler.CAPABILITY_MAGNET).orElse(null);
        if (cap != null) {
            INBT shareTag = nbt.func_74781_a("forcecraft");
            MagnetStorage.deserializeNBT(cap, shareTag);
        }
        super.readShareTag(stack, nbt);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> lores, ITooltipFlag flagIn) {
        MagnetStorage.attachInformation(stack, lores);
        super.func_77624_a(stack, worldIn, lores, flagIn);
    }
}

