/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.mrbysco.forcecraft.ForceCraft;
import com.mrbysco.forcecraft.capablilities.CapabilityHandler;
import com.mrbysco.forcecraft.capablilities.forcewrench.ForceWrenchProvider;
import com.mrbysco.forcecraft.capablilities.forcewrench.ForceWrenchStorage;
import com.mrbysco.forcecraft.capablilities.forcewrench.IForceWrench;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import com.mrbysco.forcecraft.items.infuser.IForceChargingTool;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ForceWrenchItem
extends BaseItem
implements IForceChargingTool {
    public ForceWrenchItem(Item.Properties name) {
        super(name.func_200917_a(1));
    }

    public void func_77622_d(ItemStack stack, World world, PlayerEntity player) {
        super.func_77622_d(stack, world, player);
        this.initializeTag(stack);
    }

    public void func_77663_a(ItemStack stack, World level, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, level, entityIn, itemSlot, isSelected);
        if (stack.func_77978_p() == null) {
            this.initializeTag(stack);
        }
    }

    private void initializeTag(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74757_a("ForceInfused", false);
        stack.func_77982_d(tag);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Hand hand = context.func_221531_n();
        if (stack.func_77973_b() instanceof ForceWrenchItem) {
            if (player.func_213453_ef()) {
                IForceWrench wrenchCap = (IForceWrench)stack.getCapability(CapabilityHandler.CAPABILITY_FORCEWRENCH).orElse(null);
                if (wrenchCap != null) {
                    if (world.func_175625_s(pos) instanceof TileEntity && !wrenchCap.canStoreBlock()) {
                        return this.serializeNBT(world, pos, player, hand);
                    }
                    if (wrenchCap.canStoreBlock()) {
                        this.placeBlockFromWrench(world, pos, player, hand, context.func_196000_l());
                    }
                }
            } else {
                ForceToolData fd = new ForceToolData(stack);
                if (fd.getForce() >= 10) {
                    BlockState state = world.func_180495_p(pos);
                    if (state.func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
                        world.func_175656_a(pos, state.rotate((IWorld)world, pos, Rotation.CLOCKWISE_90));
                        fd.setForce(fd.getForce() - 10);
                        fd.write(stack);
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("forcecraft.wrench_rotate.insufficient", new Object[]{10}).func_240699_a_(TextFormatting.RED), true);
                }
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (CapabilityHandler.CAPABILITY_FORCEWRENCH == null) {
            return null;
        }
        return new ForceWrenchProvider();
    }

    private ActionResultType serializeNBT(World world, BlockPos pos, PlayerEntity player, Hand hand) {
        ItemStack heldWrench = player.func_184586_b(hand);
        ForceToolData fd = new ForceToolData(heldWrench);
        if (fd.getForce() >= 250) {
            BlockState state = world.func_180495_p(pos);
            if (state.func_185905_o() == PushReaction.BLOCK) {
                return ActionResultType.FAIL;
            }
            IForceWrench wrenchCap = (IForceWrench)heldWrench.getCapability(CapabilityHandler.CAPABILITY_FORCEWRENCH).orElse(null);
            if (wrenchCap != null) {
                String blockName = state.func_177230_c().func_149739_a();
                TileEntity tileEntity = world.func_175625_s(pos);
                if (tileEntity != null) {
                    CompoundNBT nbt = tileEntity.func_189515_b(new CompoundNBT());
                    wrenchCap.storeBlockNBT(nbt);
                    wrenchCap.storeBlockState(state);
                    wrenchCap.setBlockName(blockName);
                    world.func_175713_t(pos);
                }
                fd.setForce(fd.getForce() - 250);
                fd.write(heldWrench);
                BlockState airState = Blocks.field_150350_a.func_176223_P();
                world.func_175656_a(pos, airState);
                return ActionResultType.SUCCESS;
            }
        } else {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("forcecraft.wrench_transport.insufficient", new Object[]{250}).func_240699_a_(TextFormatting.RED), true);
        }
        return ActionResultType.FAIL;
    }

    private ActionResultType placeBlockFromWrench(World world, BlockPos pos, PlayerEntity player, Hand hand, Direction side) {
        ItemStack heldWrench = player.func_184586_b(hand);
        IForceWrench wrenchCap = (IForceWrench)heldWrench.getCapability(CapabilityHandler.CAPABILITY_FORCEWRENCH).orElse(null);
        if (wrenchCap != null && wrenchCap.getStoredBlockState() != null) {
            BlockState state = wrenchCap.getStoredBlockState();
            BlockPos offPos = pos.func_177972_a(side);
            if (state != null) {
                world.func_175656_a(offPos, state);
            }
            if (wrenchCap.getStoredBlockNBT() != null && state.func_177230_c().hasTileEntity(state)) {
                CompoundNBT blockTag = wrenchCap.getStoredBlockNBT();
                TileEntity te = TileEntity.func_235657_b_((BlockState)state, (CompoundNBT)blockTag);
                if (te != null) {
                    te.func_230337_a_(state, blockTag);
                    te.func_174878_a(offPos);
                    world.func_175690_a(offPos, te);
                    te.func_70296_d();
                } else if (blockTag != null) {
                    ForceCraft.LOGGER.error("Was unable to load block entity");
                }
            }
            wrenchCap.clearBlockStorage();
        }
        return ActionResultType.SUCCESS;
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT nbt = super.getShareTag(stack);
        IForceWrench cap = (IForceWrench)stack.getCapability(CapabilityHandler.CAPABILITY_FORCEWRENCH).orElse(null);
        if (cap != null) {
            CompoundNBT shareTag = ForceWrenchStorage.serializeNBT(cap);
            if (nbt == null) {
                nbt = new CompoundNBT();
            }
            nbt.func_218657_a("forcecraft", (INBT)shareTag);
        }
        return nbt;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (nbt == null || !nbt.func_74764_b("forcecraft")) {
            return;
        }
        IForceWrench cap = (IForceWrench)stack.getCapability(CapabilityHandler.CAPABILITY_FORCEWRENCH).orElse(null);
        if (cap != null) {
            INBT shareTag = nbt.func_74781_a("forcecraft");
            ForceWrenchStorage.deserializeNBT(cap, shareTag);
        }
        super.readShareTag(stack, nbt);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> lores, ITooltipFlag flagIn) {
        ForceWrenchStorage.attachInformation(stack, lores);
        super.func_77624_a(stack, worldIn, lores, flagIn);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return this.damageItem(stack, amount);
    }
}

