/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.mrbysco.forcecraft.capablilities.CapabilityHandler;
import com.mrbysco.forcecraft.capablilities.toolmodifier.IToolModifier;
import com.mrbysco.forcecraft.capablilities.toolmodifier.ToolModProvider;
import com.mrbysco.forcecraft.capablilities.toolmodifier.ToolModStorage;
import com.mrbysco.forcecraft.entities.ColdChickenEntity;
import com.mrbysco.forcecraft.entities.ColdCowEntity;
import com.mrbysco.forcecraft.entities.ColdPigEntity;
import com.mrbysco.forcecraft.entities.IColdMob;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import com.mrbysco.forcecraft.items.infuser.IForceChargingTool;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShearsItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ForceShearsItem
extends ShearsItem
implements IForceChargingTool {
    private static final int SET_FIRE_TIME = 10;
    private static final int SHEARS_DMG = 238;
    private static final Item[] WOOL = new Item[]{Items.field_221617_aS, Items.field_221614_aP, Items.field_221618_aT, Items.field_221614_aP, Items.field_221615_aQ, Items.field_221603_aE, Items.field_221604_aF, Items.field_221605_aG, Items.field_221606_aH, Items.field_221607_aI, Items.field_221608_aJ, Items.field_221609_aK, Items.field_221610_aL, Items.field_221611_aM, Items.field_221612_aN, Items.field_221613_aO, Items.field_221615_aQ, Items.field_221616_aR};

    public ForceShearsItem(Item.Properties properties) {
        super(properties.func_200917_a(1).func_200918_c(952));
    }

    private ItemStack getRandomWool(World world) {
        return new ItemStack((IItemProvider)WOOL[MathHelper.func_76136_a((Random)world.field_73012_v, (int)0, (int)WOOL.length)]);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity entity, Hand hand) {
        boolean hasHeat;
        BlockPos pos;
        SheepEntity target;
        World world = entity.field_70170_p;
        if (world.field_72995_K) {
            return ActionResultType.PASS;
        }
        Random rand = world.field_73012_v;
        IToolModifier toolModifier = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
        if (toolModifier != null && toolModifier.hasRainbow() && entity instanceof SheepEntity && (target = (SheepEntity)entity).isShearable(stack, world, pos = new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()))) {
            List drops = target.onSheared(playerIn, stack, world, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
            for (int i = 0; i < drops.size(); ++i) {
                ItemEntity ent = entity.func_70099_a(this.getRandomWool(world), 1.0f);
                ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
            }
            stack.func_222118_a(1, entity, e -> e.func_213334_d(hand));
            return ActionResultType.SUCCESS;
        }
        boolean bl = hasHeat = toolModifier != null && toolModifier.hasHeat();
        if (!(entity instanceof IColdMob)) {
            if (entity instanceof CowEntity && !(entity instanceof MooshroomEntity)) {
                CowEntity originalCow = (CowEntity)entity;
                int i = 1 + rand.nextInt(3);
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                for (int j = 0; j < i; ++j) {
                    drops.add(new ItemStack((IItemProvider)Items.field_151116_aA, 1));
                }
                drops.forEach(d -> {
                    ItemEntity ent = entity.func_70099_a(d, 1.0f);
                    ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                });
                entity.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
                ColdCowEntity replacementMob = new ColdCowEntity(world, originalCow.func_200600_R().getRegistryName());
                replacementMob.func_82149_j((Entity)originalCow);
                UUID mobUUID = replacementMob.func_110124_au();
                replacementMob.func_180432_n((Entity)originalCow);
                replacementMob.func_184221_a(mobUUID);
                originalCow.remove(false);
                world.func_217376_c((Entity)replacementMob);
                if (hasHeat) {
                    replacementMob.func_70015_d(10);
                }
                stack.func_222118_a(1, entity, e -> e.func_213334_d(hand));
                return ActionResultType.SUCCESS;
            }
            if (entity instanceof ChickenEntity) {
                ChickenEntity originalChicken = (ChickenEntity)entity;
                World worldIn = originalChicken.field_70170_p;
                int i = 1 + rand.nextInt(3);
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                for (int j = 0; j < i; ++j) {
                    drops.add(new ItemStack((IItemProvider)Items.field_151008_G, 1));
                }
                drops.forEach(d -> {
                    ItemEntity ent = entity.func_70099_a(d, 1.0f);
                    ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                });
                entity.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
                ColdChickenEntity replacementMob = new ColdChickenEntity(worldIn, originalChicken.func_200600_R().getRegistryName());
                replacementMob.func_82149_j((Entity)originalChicken);
                UUID mobUUID = replacementMob.func_110124_au();
                replacementMob.func_180432_n((Entity)originalChicken);
                replacementMob.func_184221_a(mobUUID);
                originalChicken.remove(false);
                worldIn.func_217376_c((Entity)replacementMob);
                if (hasHeat) {
                    replacementMob.func_70015_d(10);
                }
                stack.func_222118_a(1, entity, e -> e.func_213334_d(hand));
                return ActionResultType.SUCCESS;
            }
            if (entity instanceof PigEntity) {
                PigEntity originalPig = (PigEntity)entity;
                World worldIn = originalPig.field_70170_p;
                int i = 1 + rand.nextInt(2);
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                for (int j = 0; j < i; ++j) {
                    drops.add(new ItemStack(hasHeat ? (IItemProvider)ForceRegistry.COOKED_BACON.get() : (IItemProvider)ForceRegistry.RAW_BACON.get(), 1));
                }
                drops.forEach(d -> {
                    ItemEntity ent = entity.func_70099_a(d, 1.0f);
                    ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                });
                entity.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
                ColdPigEntity replacementMob = new ColdPigEntity(worldIn, originalPig.func_200600_R().getRegistryName());
                replacementMob.func_82149_j((Entity)originalPig);
                UUID mobUUID = replacementMob.func_110124_au();
                replacementMob.func_180432_n((Entity)originalPig);
                replacementMob.func_184221_a(mobUUID);
                originalPig.remove(false);
                worldIn.func_217376_c((Entity)replacementMob);
                if (hasHeat) {
                    replacementMob.func_70015_d(10);
                }
                stack.func_222118_a(1, entity, e -> e.func_213334_d(hand));
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_111207_a(stack, playerIn, entity, hand);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (CapabilityHandler.CAPABILITY_TOOLMOD == null) {
            return null;
        }
        return new ToolModProvider();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> lores, ITooltipFlag flagIn) {
        ForceToolData fd = new ForceToolData(stack);
        fd.attachInformation(lores);
        ToolModStorage.attachInformation(stack, lores);
        super.func_77624_a(stack, worldIn, lores, flagIn);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return this.damageItem(stack, amount);
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT nbt = super.getShareTag(stack);
        IToolModifier cap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
        if (cap != null) {
            CompoundNBT shareTag = ToolModStorage.serializeNBT(cap);
            nbt.func_218657_a("forcecraft", (INBT)shareTag);
        }
        return nbt;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (nbt == null || !nbt.func_74764_b("forcecraft")) {
            return;
        }
        IToolModifier cap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
        if (cap != null) {
            INBT shareTag = nbt.func_74781_a("forcecraft");
            ToolModStorage.deserializeNBT(cap, shareTag);
        }
        super.readShareTag(stack, nbt);
    }
}

