/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.mrbysco.forcecraft.Reference;
import com.mrbysco.forcecraft.capablilities.CapabilityHandler;
import com.mrbysco.forcecraft.capablilities.forcerod.ForceRodProvider;
import com.mrbysco.forcecraft.capablilities.forcerod.ForceRodStorage;
import com.mrbysco.forcecraft.capablilities.forcerod.IForceRodModifier;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import com.mrbysco.forcecraft.items.infuser.IForceChargingTool;
import com.mrbysco.forcecraft.items.nonburnable.InertCoreItem;
import com.mrbysco.forcecraft.items.nonburnable.NonBurnableItemEntity;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.FireBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ForceRodItem
extends BaseItem
implements IForceChargingTool {
    public List<Reference.MODIFIERS> applicableModifiers = new ArrayList<Reference.MODIFIERS>();

    public ForceRodItem(Item.Properties properties) {
        super(properties.func_200918_c(75));
        this.setApplicableModifiers();
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        PlayerEntity player = context.func_195999_j();
        Hand handIn = context.func_221531_n();
        ItemStack stack = context.func_195996_i();
        if (!worldIn.field_72995_K && player != null) {
            if (worldIn.func_180495_p(pos).func_177230_c() instanceof FireBlock) {
                worldIn.func_217377_a(pos, false);
                List list = worldIn.func_217357_a(ItemEntity.class, new AxisAlignedBB(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).func_72321_a(0.5, 1.0, 0.5));
                boolean bw = false;
                for (Entity i : list) {
                    if (!(i instanceof ItemEntity) || !(((ItemEntity)i).func_92059_d().func_77973_b() instanceof InertCoreItem)) continue;
                    NonBurnableItemEntity bottledWither = new NonBurnableItemEntity(worldIn, pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p(), new ItemStack((IItemProvider)ForceRegistry.BOTTLED_WITHER.get(), ((ItemEntity)i).func_92059_d().func_190916_E()));
                    worldIn.func_217376_c((Entity)bottledWither);
                    stack.func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(handIn));
                    bw = true;
                }
                if (bw) {
                    for (Entity i : list) {
                        if (!(i instanceof ItemEntity) || !(((ItemEntity)i).func_92059_d().func_77973_b() instanceof InertCoreItem)) continue;
                        i.func_70106_y();
                    }
                }
            } else {
                List list = worldIn.func_217357_a(ItemEntity.class, new AxisAlignedBB(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).func_72321_a(0.5, 1.0, 0.5));
                for (Entity i : list) {
                    if (!(i instanceof ItemEntity) || !(((ItemEntity)i).func_92059_d().func_77973_b() instanceof ArmorItem)) continue;
                    if (((ArmorItem)((ItemEntity)i).func_92059_d().func_77973_b()).func_185083_B_() == EquipmentSlotType.CHEST) {
                        if (((ArmorItem)((ItemEntity)i).func_92059_d().func_77973_b()).func_200880_d() == ArmorMaterial.IRON) {
                            i.func_70106_y();
                            worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), new ItemStack((IItemProvider)Items.field_151042_j, 6)));
                            stack.func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(handIn));
                        } else if (((ArmorItem)((ItemEntity)i).func_92059_d().func_77973_b()).func_200880_d() == ArmorMaterial.GOLD) {
                            i.func_70106_y();
                            worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), new ItemStack((IItemProvider)Items.field_151043_k, 6)));
                            stack.func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(handIn));
                        } else if (((ArmorItem)((ItemEntity)i).func_92059_d().func_77973_b()).func_200880_d() == ArmorMaterial.LEATHER) {
                            i.func_70106_y();
                            worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), new ItemStack((IItemProvider)ForceRegistry.FORCE_CHEST.get(), 1)));
                            stack.func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(handIn));
                        }
                    }
                    if (((ArmorItem)((ItemEntity)i).func_92059_d().func_77973_b()).func_185083_B_() == EquipmentSlotType.LEGS) {
                        if (((ArmorItem)((ItemEntity)i).func_92059_d().func_77973_b()).func_200880_d() == ArmorMaterial.IRON) {
                            i.func_70106_y();
                            worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), new ItemStack((IItemProvider)Items.field_151042_j, 5)));
                            stack.func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(handIn));
                        } else if (((ArmorItem)((ItemEntity)i).func_92059_d().func_77973_b()).func_200880_d() == ArmorMaterial.GOLD) {
                            i.func_70106_y();
                            worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), new ItemStack((IItemProvider)Items.field_151043_k, 5)));
                            stack.func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(handIn));
                        } else if (((ArmorItem)((ItemEntity)i).func_92059_d().func_77973_b()).func_200880_d() == ArmorMaterial.LEATHER) {
                            i.func_70106_y();
                            worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), new ItemStack((IItemProvider)ForceRegistry.FORCE_LEGS.get(), 1)));
                            stack.func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(handIn));
                        }
                    }
                    if (((ArmorItem)((ItemEntity)i).func_92059_d().func_77973_b()).func_185083_B_() == EquipmentSlotType.FEET) {
                        if (((ArmorItem)((ItemEntity)i).func_92059_d().func_77973_b()).func_200880_d() == ArmorMaterial.IRON) {
                            i.func_70106_y();
                            worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), new ItemStack((IItemProvider)Items.field_151042_j, 3)));
                            stack.func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(handIn));
                        } else if (((ArmorItem)((ItemEntity)i).func_92059_d().func_77973_b()).func_200880_d() == ArmorMaterial.GOLD) {
                            i.func_70106_y();
                            worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), new ItemStack((IItemProvider)Items.field_151043_k, 3)));
                            stack.func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(handIn));
                        } else if (((ArmorItem)((ItemEntity)i).func_92059_d().func_77973_b()).func_200880_d() == ArmorMaterial.LEATHER) {
                            i.func_70106_y();
                            worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), new ItemStack((IItemProvider)ForceRegistry.FORCE_BOOTS.get(), 1)));
                            stack.func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(handIn));
                        }
                    }
                    if (((ArmorItem)((ItemEntity)i).func_92059_d().func_77973_b()).func_185083_B_() != EquipmentSlotType.HEAD) continue;
                    if (((ArmorItem)((ItemEntity)i).func_92059_d().func_77973_b()).func_200880_d() == ArmorMaterial.IRON) {
                        i.func_70106_y();
                        worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), new ItemStack((IItemProvider)Items.field_151042_j, 4)));
                        stack.func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(handIn));
                        continue;
                    }
                    if (((ArmorItem)((ItemEntity)i).func_92059_d().func_77973_b()).func_200880_d() == ArmorMaterial.GOLD) {
                        i.func_70106_y();
                        worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), new ItemStack((IItemProvider)Items.field_151043_k, 4)));
                        stack.func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(handIn));
                        continue;
                    }
                    if (((ArmorItem)((ItemEntity)i).func_92059_d().func_77973_b()).func_200880_d() != ArmorMaterial.LEATHER) continue;
                    i.func_70106_y();
                    worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), new ItemStack((IItemProvider)ForceRegistry.FORCE_HELMET.get(), 1)));
                    stack.func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(handIn));
                }
            }
        }
        stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).ifPresent(cap -> {
            if (cap.hasEnderModifier()) {
                if (player.func_225608_bj_()) {
                    cap.setHomeLocation(GlobalPos.func_239648_a_((RegistryKey)player.field_70170_p.func_234923_W_(), (BlockPos)player.func_233580_cy_()));
                    if (!worldIn.field_72995_K) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("forcecraft.ender_rod.location.set").func_240699_a_(TextFormatting.DARK_PURPLE), true);
                    }
                } else if (cap.getHomeLocation() != null) {
                    cap.teleportPlayerToLocation(player, cap.getHomeLocation());
                    stack.func_222118_a(1, (LivingEntity)player, playerIn -> player.func_213334_d(handIn));
                    player.func_184811_cZ().func_185145_a((Item)this, 10);
                    worldIn.func_184148_a((PlayerEntity)null, player.field_70169_q, player.field_70167_r, player.field_70166_s, SoundEvents.field_187534_aX, player.func_184176_by(), 1.0f, 1.0f);
                    player.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                }
            }
        });
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn != null) {
            stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).ifPresent(cap -> {
                if (cap.getHealingLevel() > 0) {
                    int healingLevel = cap.getHealingLevel();
                    playerIn.func_195064_c(new EffectInstance(Effects.field_76428_l, 100, healingLevel - 1, false, false));
                    stack.func_222118_a(1, (LivingEntity)playerIn, player -> player.func_213334_d(handIn));
                    playerIn.func_184811_cZ().func_185145_a((Item)this, 10);
                }
                if (cap.hasCamoModifier()) {
                    playerIn.func_195064_c(new EffectInstance(Effects.field_76441_p, 1000, 0, false, false));
                    stack.func_222118_a(1, (LivingEntity)playerIn, player -> player.func_213334_d(handIn));
                    playerIn.func_184811_cZ().func_185145_a((Item)this, 10);
                }
                if (cap.hasEnderModifier()) {
                    if (playerIn.func_225608_bj_()) {
                        cap.setHomeLocation(GlobalPos.func_239648_a_((RegistryKey)playerIn.field_70170_p.func_234923_W_(), (BlockPos)playerIn.func_233580_cy_()));
                    } else if (cap.getHomeLocation() != null) {
                        cap.teleportPlayerToLocation(playerIn, cap.getHomeLocation());
                        stack.func_222118_a(1, (LivingEntity)playerIn, player -> player.func_213334_d(handIn));
                        playerIn.func_184811_cZ().func_185145_a((Item)this, 10);
                        worldIn.func_184148_a((PlayerEntity)null, playerIn.field_70169_q, playerIn.field_70167_r, playerIn.field_70166_s, SoundEvents.field_187534_aX, playerIn.func_184176_by(), 1.0f, 1.0f);
                        playerIn.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                    }
                }
                if (cap.hasSightModifier()) {
                    playerIn.func_195064_c(new EffectInstance(Effects.field_76439_r, 1000, 0, false, false));
                    stack.func_222118_a(1, (LivingEntity)playerIn, player -> player.func_213334_d(handIn));
                    playerIn.func_184811_cZ().func_185145_a((Item)this, 10);
                }
                if (cap.hasLight()) {
                    playerIn.func_195064_c(new EffectInstance(Effects.field_188423_x, 1000, 0, false, false));
                    stack.func_222118_a(1, (LivingEntity)playerIn, player -> player.func_213334_d(handIn));
                    playerIn.func_184811_cZ().func_185145_a((Item)this, 10);
                }
                if (cap.getSpeedLevel() > 0) {
                    playerIn.func_195064_c(new EffectInstance(Effects.field_76424_c, 200, cap.getSpeedLevel() - 1, false, false));
                    stack.func_222118_a(1, (LivingEntity)playerIn, player -> player.func_213334_d(handIn));
                    playerIn.func_184811_cZ().func_185145_a((Item)this, 10);
                }
            });
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand handIn) {
        if (playerIn != null) {
            stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).ifPresent(cap -> {
                if (cap.hasLight()) {
                    target.func_195064_c(new EffectInstance(Effects.field_188423_x, 2400, 0, false, false));
                    stack.func_222118_a(1, (LivingEntity)playerIn, player -> player.func_213334_d(handIn));
                    playerIn.func_184811_cZ().func_185145_a((Item)this, 10);
                }
            });
        }
        return super.func_111207_a(stack, playerIn, target, handIn);
    }

    public void func_77663_a(ItemStack stack, World level, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, level, entityIn, itemSlot, isSelected);
        if (stack.func_77978_p() != null && !stack.func_77978_p().func_74764_b("ForceInfused")) {
            this.initializeTag(stack);
        }
    }

    private void initializeTag(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74757_a("ForceInfused", false);
        stack.func_77982_d(tag);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (CapabilityHandler.CAPABILITY_FORCEROD == null) {
            return null;
        }
        return new ForceRodProvider();
    }

    public void setApplicableModifiers() {
        this.applicableModifiers.add(Reference.MODIFIERS.MOD_HEALING);
        this.applicableModifiers.add(Reference.MODIFIERS.MOD_ENDER);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return this.damageItem(stack, amount);
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT nbt = super.getShareTag(stack);
        IForceRodModifier cap = (IForceRodModifier)stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).orElse(null);
        if (cap != null) {
            CompoundNBT shareTag = ForceRodStorage.serializeNBT(cap);
            nbt.func_218657_a("forcecraft", (INBT)shareTag);
        }
        return nbt;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (nbt == null || !nbt.func_74764_b("forcecraft")) {
            return;
        }
        IForceRodModifier cap = (IForceRodModifier)stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).orElse(null);
        if (cap != null) {
            INBT shareTag = nbt.func_74781_a("forcecraft");
            ForceRodStorage.deserializeNBT(cap, shareTag);
        }
        super.readShareTag(stack, nbt);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> lores, ITooltipFlag flagIn) {
        ForceToolData fd = new ForceToolData(stack);
        fd.attachInformation(lores);
        ForceRodStorage.attachInformation(stack, lores);
        super.func_77624_a(stack, worldIn, lores, flagIn);
    }
}

