/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.mrbysco.forcecraft.capablilities.CapabilityHandler;
import com.mrbysco.forcecraft.capablilities.toolmodifier.IToolModifier;
import com.mrbysco.forcecraft.capablilities.toolmodifier.ToolModProvider;
import com.mrbysco.forcecraft.capablilities.toolmodifier.ToolModStorage;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import com.mrbysco.forcecraft.items.infuser.IForceChargingTool;
import com.mrbysco.forcecraft.registry.material.ModToolMaterial;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ForcePickaxeItem
extends PickaxeItem
implements IForceChargingTool {
    public ForcePickaxeItem(Item.Properties properties) {
        super((IItemTier)ModToolMaterial.FORCE, -6, -2.8f, properties);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (CapabilityHandler.CAPABILITY_TOOLMOD == null) {
            return null;
        }
        return new ToolModProvider();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> lores, ITooltipFlag flagIn) {
        ForceToolData fd = new ForceToolData(stack);
        fd.attachInformation(lores);
        ToolModStorage.attachInformation(stack, lores);
        super.func_77624_a(stack, worldIn, lores, flagIn);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return this.damageItem(stack, amount);
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT nbt = super.getShareTag(stack);
        IToolModifier cap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
        if (cap != null) {
            CompoundNBT shareTag = ToolModStorage.serializeNBT(cap);
            nbt.func_218657_a("forcecraft", (INBT)shareTag);
        }
        return nbt;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (nbt == null || !nbt.func_74764_b("forcecraft")) {
            return;
        }
        IToolModifier cap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
        if (cap != null) {
            INBT shareTag = nbt.func_74781_a("forcecraft");
            ToolModStorage.deserializeNBT(cap, shareTag);
        }
        super.readShareTag(stack, nbt);
    }
}

