/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.mrbysco.forcecraft.networking.PacketHandler;
import com.mrbysco.forcecraft.registry.ForceSounds;
import com.mrbysco.forcecraft.registry.material.ModToolMaterial;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ToolItem;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.ForgeEventFactory;

public class ForceMittItem
extends ToolItem {
    private final float attackDamage;
    private final IItemTier itemTier = ModToolMaterial.FORCE;
    private static final Set<Material> EFFECTIVE_MATERIALS = ImmutableSet.of((Object)Material.field_151576_e, (Object)Material.field_151573_f, (Object)Material.field_151588_w, (Object)Material.field_151592_s, (Object)Material.field_76233_E, (Object)Material.field_151574_g, (Object[])new Material[]{Material.field_151594_q, Material.field_151575_d, Material.field_237214_y_, Material.field_151585_k, Material.field_151582_l, Material.field_215713_z, Material.field_151572_C, Material.field_204868_h, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z, Material.field_151571_B, Material.field_151584_j});

    public ForceMittItem(Item.Properties properties) {
        super(8.0f, 8.0f, (IItemTier)ModToolMaterial.FORCE, Collections.emptySet(), properties.func_200918_c(1000));
        this.attackDamage = 3.0f;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (entityLiving instanceof PlayerEntity && state.func_185904_a() == Material.field_151584_j) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            BlockRayTraceResult traceResult = ForceMittItem.func_219968_a((World)worldIn, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
            switch (traceResult.func_216354_b().func_176740_k()) {
                case X: {
                    this.breakBlockAt(player, worldIn, stack, pos.func_177984_a());
                    this.breakBlockAt(player, worldIn, stack, pos.func_177977_b());
                    this.breakBlockAt(player, worldIn, stack, pos.func_177978_c());
                    this.breakBlockAt(player, worldIn, stack, pos.func_177978_c().func_177984_a());
                    this.breakBlockAt(player, worldIn, stack, pos.func_177978_c().func_177977_b());
                    this.breakBlockAt(player, worldIn, stack, pos.func_177968_d());
                    this.breakBlockAt(player, worldIn, stack, pos.func_177968_d().func_177984_a());
                    this.breakBlockAt(player, worldIn, stack, pos.func_177968_d().func_177977_b());
                    break;
                }
                case Z: {
                    this.breakBlockAt(player, worldIn, stack, pos.func_177984_a());
                    this.breakBlockAt(player, worldIn, stack, pos.func_177977_b());
                    this.breakBlockAt(player, worldIn, stack, pos.func_177976_e());
                    this.breakBlockAt(player, worldIn, stack, pos.func_177976_e().func_177984_a());
                    this.breakBlockAt(player, worldIn, stack, pos.func_177976_e().func_177977_b());
                    this.breakBlockAt(player, worldIn, stack, pos.func_177974_f());
                    this.breakBlockAt(player, worldIn, stack, pos.func_177974_f().func_177984_a());
                    this.breakBlockAt(player, worldIn, stack, pos.func_177974_f().func_177977_b());
                    break;
                }
                case Y: {
                    this.breakBlockAt(player, worldIn, stack, pos.func_177978_c());
                    this.breakBlockAt(player, worldIn, stack, pos.func_177974_f());
                    this.breakBlockAt(player, worldIn, stack, pos.func_177976_e());
                    this.breakBlockAt(player, worldIn, stack, pos.func_177976_e().func_177978_c());
                    this.breakBlockAt(player, worldIn, stack, pos.func_177976_e().func_177974_f());
                    this.breakBlockAt(player, worldIn, stack, pos.func_177974_f());
                    this.breakBlockAt(player, worldIn, stack, pos.func_177974_f().func_177978_c());
                    this.breakBlockAt(player, worldIn, stack, pos.func_177974_f().func_177974_f());
                }
            }
            worldIn.func_184133_a((PlayerEntity)null, pos, (SoundEvent)ForceSounds.WHOOSH.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    public void breakBlockAt(PlayerEntity player, World worldIn, ItemStack stack, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (worldIn.func_180495_p(pos).func_185904_a() == Material.field_151584_j) {
            BlockState state = worldIn.func_180495_p(pos);
            if (!ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)player, (IBlockReader)worldIn, (BlockPos)pos)) {
                return;
            }
            if (!worldIn.field_72995_K) {
                int xp = ForgeHooks.onBlockBreakEvent((World)worldIn, (GameType)((ServerPlayerEntity)player).field_71134_c.func_73081_b(), (ServerPlayerEntity)((ServerPlayerEntity)player), (BlockPos)pos);
                if (xp == -1) {
                    return;
                }
                FluidState fluidState = worldIn.func_204610_c(pos);
                Block block = state.func_177230_c();
                if (block.removedByPlayer(state, worldIn, pos, player, true, fluidState)) {
                    block.func_176208_a(worldIn, pos, state, player);
                    block.func_180657_a(worldIn, player, pos, state, tileEntity, stack);
                    block.func_180637_b((ServerWorld)worldIn, pos, xp);
                }
                ((ServerWorld)worldIn).func_195598_a((IParticleData)ParticleTypes.field_197603_N, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1, 0.0, 0.0, 0.0, 0.0);
                PacketHandler.sendPacket((Entity)player, new SChangeBlockPacket((IBlockReader)worldIn, pos));
            }
        }
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        if (tool == ToolType.PICKAXE) {
            return this.itemTier.func_200925_d();
        }
        if (tool == ToolType.AXE) {
            return this.itemTier.func_200925_d();
        }
        if (tool == ToolType.SHOVEL) {
            return this.itemTier.func_200925_d();
        }
        if (tool == ToolType.get((String)"sword")) {
            return this.itemTier.func_200925_d();
        }
        return super.getHarvestLevel(stack, tool, player, blockState);
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockState blockstate;
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        int hook = ForgeEventFactory.onHoeUse((ItemUseContext)context);
        if (hook != 0) {
            return hook > 0 ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        if (context.func_196000_l() != Direction.DOWN && world.func_175623_d(blockpos.func_177984_a()) && (blockstate = world.func_180495_p(blockpos).getToolModifiedState(world, blockpos, context.func_195999_j(), context.func_195996_i(), ToolType.HOE)) != null) {
            PlayerEntity playerentity = context.func_195999_j();
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, blockstate, 11);
                if (playerentity != null) {
                    context.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, player -> player.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        blockstate = world.func_180495_p(blockpos);
        BlockState block = blockstate.getToolModifiedState(world, blockpos, context.func_195999_j(), context.func_195996_i(), ToolType.AXE);
        if (block != null) {
            PlayerEntity playerentity = context.func_195999_j();
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, block, 11);
                if (playerentity != null) {
                    context.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, p_220040_1_ -> p_220040_1_.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Material material = state.func_185904_a();
        return EFFECTIVE_MATERIALS.contains(material) ? 14.0f : super.func_150893_a(stack, state);
    }

    public float func_234675_d_() {
        return this.itemTier.func_200929_c();
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, attackerEntity -> attackerEntity.func_213334_d(Hand.MAIN_HAND));
        return true;
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EquipmentSlotType.MAINHAND && multimap != null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon damage modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon speed modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
            multimap = builder.build();
        }
        return multimap;
    }

    public boolean func_150897_b(BlockState blockIn) {
        return EFFECTIVE_MATERIALS.contains(blockIn.func_185904_a()) || blockIn.func_203425_a(Blocks.field_196553_aF);
    }
}

