/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.infuser;

import com.mrbysco.forcecraft.ForceCraft;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookTier;
import com.mrbysco.forcecraft.recipe.InfuseRecipe;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;

public class UpgradeBookData {
    private UpgradeBookTier tier = UpgradeBookTier.ZERO;
    private final Map<Integer, Set<ResourceLocation>> recipesUsed = new HashMap<Integer, Set<ResourceLocation>>();
    private int points = 0;
    private String progressCache = "";

    public UpgradeBookData(ItemStack book) {
        if (book.func_77973_b() != ForceRegistry.UPGRADE_TOME.get()) {
            ForceCraft.LOGGER.error("invalid book data entering book {}", (Object)book);
            return;
        }
        CompoundNBT tag = book.func_77978_p();
        if (tag != null && tag.func_74764_b("tier")) {
            this.read(book, tag);
        } else {
            this.updateCache();
            this.write(book);
        }
    }

    public int nextTier() {
        if (this.getTier() == UpgradeBookTier.FINAL) {
            return 0;
        }
        return Math.max(0, this.getTier().pointsForLevelup() - this.points);
    }

    public void onRecipeApply(InfuseRecipe recipe, ItemStack bookStack) {
        Integer tier = recipe.getTier().ordinal();
        Set<ResourceLocation> tierSet = new HashSet<ResourceLocation>();
        if (this.recipesUsed.containsKey(tier)) {
            tierSet = this.recipesUsed.get(tier);
        }
        tierSet.add(recipe.func_199560_c());
        this.recipesUsed.put(tier, tierSet);
        this.tryLevelUp();
        this.write(bookStack);
    }

    public void incrementPoints(int incoming) {
        this.points += incoming;
        this.tryLevelUp();
    }

    private void tryLevelUp() {
        if (this.canLevelUp()) {
            this.points -= this.getTier().pointsForLevelup();
            this.setTier(this.getTier().incrementTier());
            this.updateCache();
        }
    }

    private void updateCache() {
        int recipesThisTier;
        Set<ResourceLocation> thisTier = this.recipesUsed.get(this.tier.ordinal());
        int n = recipesThisTier = thisTier == null ? 0 : thisTier.size();
        if (!InfuseRecipe.RECIPESBYLEVEL.isEmpty()) {
            int totalThisTier = InfuseRecipe.RECIPESBYLEVEL.get(this.tier.ordinal()).size();
            this.progressCache = recipesThisTier + "/" + totalThisTier;
        }
    }

    private boolean canLevelUp() {
        Set<ResourceLocation> thisTier = this.recipesUsed.get(this.tier.ordinal());
        int recipesThisTier = thisTier == null ? 0 : thisTier.size();
        int totalThisTier = InfuseRecipe.RECIPESBYLEVEL.get(this.tier.ordinal()).size();
        this.updateCache();
        if (this.points < this.getTier().pointsForLevelup() || this.getTier() == UpgradeBookTier.FINAL) {
            return false;
        }
        return recipesThisTier >= totalThisTier;
    }

    private void read(ItemStack book, CompoundNBT tag) {
        this.progressCache = tag.func_74779_i("progressCache");
        this.setTier(UpgradeBookTier.values()[tag.func_74762_e("tier")]);
        this.points = tag.func_74762_e("points");
        for (UpgradeBookTier tier : UpgradeBookTier.values()) {
            HashSet<ResourceLocation> tierSet = new HashSet<ResourceLocation>();
            ListNBT listTag = (ListNBT)tag.func_74781_a("tier" + tier.ordinal());
            if (listTag != null) {
                for (int i = 0; i < listTag.size(); ++i) {
                    CompoundNBT tg = (CompoundNBT)listTag.get(i);
                    String id = tg.func_74779_i("id");
                    if (id.isEmpty() || "minecraft:".equalsIgnoreCase(id)) continue;
                    tierSet.add(ResourceLocation.func_208304_a((String)id));
                }
            }
            this.recipesUsed.put(tier.ordinal(), tierSet);
        }
    }

    public CompoundNBT write(ItemStack bookInSlot) {
        CompoundNBT tag = bookInSlot.func_196082_o();
        tag.func_74778_a("progressCache", this.progressCache);
        tag.func_74768_a("tier", this.getTier().ordinal());
        tag.func_74768_a("points", this.points);
        for (UpgradeBookTier tier : UpgradeBookTier.values()) {
            Set<ResourceLocation> tierSet = this.recipesUsed.get(tier.ordinal());
            if (tierSet == null) {
                tierSet = new HashSet<ResourceLocation>();
            }
            ListNBT listTag = new ListNBT();
            for (ResourceLocation id : tierSet) {
                if ("minecraft:".equalsIgnoreCase(id.toString())) continue;
                CompoundNBT tg = new CompoundNBT();
                tg.func_74778_a("id", id.toString());
                listTag.add((Object)tg);
            }
            tag.func_218657_a("tier" + tier.ordinal(), (INBT)listTag);
        }
        return tag;
    }

    public String getProgressCache() {
        return this.progressCache;
    }

    public UpgradeBookTier getTier() {
        return this.tier;
    }

    public void setTier(UpgradeBookTier tier) {
        this.tier = tier;
    }

    public int getPoints() {
        return this.points;
    }
}

