/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.flask;

import com.mrbysco.forcecraft.items.flask.ForceFilledForceFlask;
import com.mrbysco.forcecraft.items.flask.MilkFlaskItem;
import com.mrbysco.forcecraft.registry.ForceFluids;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;

public class FlaskFluidHandler
extends FluidHandlerItemStackSimple {
    public FlaskFluidHandler(@Nonnull ItemStack container) {
        super(container, 1000);
    }

    public int getTankCapacity(int tank) {
        return 1000;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    @Nonnull
    public FluidStack getFluid() {
        Item item = this.container.func_77973_b();
        if (item instanceof ForceFilledForceFlask) {
            return new FluidStack((Fluid)ForceFluids.FORCE_FLUID_SOURCE.get(), 1000);
        }
        if (item instanceof MilkFlaskItem && ForgeMod.MILK.isPresent()) {
            return new FluidStack((Fluid)ForgeMod.MILK.get(), 1000);
        }
        return FluidStack.EMPTY;
    }

    public boolean canFillFluidType(FluidStack stack) {
        for (Fluid fluid : FluidTags.func_226157_a_().func_199910_a(new ResourceLocation("forge", "force")).func_230236_b_()) {
            if (fluid != stack.getFluid()) continue;
            return true;
        }
        if (ForgeMod.MILK.isPresent()) {
            for (Fluid fluid : FluidTags.func_226157_a_().func_199910_a(new ResourceLocation("forge", "milk")).func_230236_b_()) {
                if (fluid != stack.getFluid()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.canFillFluidType(stack);
    }

    protected void setContainerToEmpty() {
        this.container = new ItemStack((IItemProvider)ForceRegistry.FORCE_FLASK.get());
    }

    protected void setFluid(FluidStack stack) {
        if (stack.isEmpty()) {
            this.setContainerToEmpty();
        } else {
            for (Fluid fluid : FluidTags.func_226157_a_().func_199910_a(new ResourceLocation("forge", "force")).func_230236_b_()) {
                if (fluid != stack.getFluid()) continue;
                this.container = new ItemStack((IItemProvider)ForceRegistry.FORCE_FILLED_FORCE_FLASK.get());
                return;
            }
            if (ForgeMod.MILK.isPresent()) {
                for (Fluid fluid : FluidTags.func_226157_a_().func_199910_a(new ResourceLocation("forge", "milk")).func_230236_b_()) {
                    if (fluid != stack.getFluid()) continue;
                    this.container = new ItemStack((IItemProvider)ForceRegistry.MILK_FORCE_FLASK.get());
                    return;
                }
            }
        }
    }
}

