/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.flask;

import com.mrbysco.forcecraft.entities.projectile.FlaskEntity;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.registry.ForceTags;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityFlaskItem
extends BaseItem {
    public EntityFlaskItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World worldIn = context.func_195991_k();
        ItemStack stack = context.func_195996_i();
        PlayerEntity playerIn = context.func_195999_j();
        if (worldIn.field_72995_K) {
            return ActionResultType.FAIL;
        }
        if (this.hasEntityStored(stack)) {
            Entity storedEntity = this.getStoredEntity(stack, worldIn);
            BlockPos pos = context.func_195995_a().func_177972_a(context.func_196000_l());
            storedEntity.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
            worldIn.func_217376_c(storedEntity);
            CompoundNBT tag = stack.func_196082_o();
            tag.func_82580_o("StoredEntity");
            tag.func_82580_o("EntityData");
            stack.func_77982_d(tag);
        } else {
            playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("item.entity_flask.empty2").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
        }
        stack.func_190918_g(1);
        ItemStack emptyFlask = new ItemStack((IItemProvider)ForceRegistry.FORCE_FLASK.get());
        if (!playerIn.field_71071_by.func_70441_a(emptyFlask)) {
            playerIn.func_70099_a(emptyFlask, 0.0f);
        }
        return super.func_195939_a(context);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (playerIn.func_225608_bj_()) {
            if (!this.hasEntityStored(itemstack)) {
                worldIn.func_184148_a((PlayerEntity)null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187827_fP, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                if (!worldIn.field_72995_K) {
                    FlaskEntity flaskEntity = new FlaskEntity(worldIn, (LivingEntity)playerIn);
                    flaskEntity.func_213884_b(itemstack);
                    flaskEntity.func_234612_a_((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, -20.0f, 0.5f, 1.0f);
                    worldIn.func_217376_c((Entity)flaskEntity);
                }
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
            } else {
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("item.entity_flask.empty").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            }
        }
        return ActionResult.func_233538_a_((Object)itemstack, (boolean)worldIn.func_201670_d());
    }

    public boolean hasEntityStored(ItemStack stack) {
        return stack.func_196082_o().func_74764_b("StoredEntity");
    }

    public Entity getStoredEntity(ItemStack stack, World worldIn) {
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(ResourceLocation.func_208304_a((String)stack.func_77978_p().func_74779_i("StoredEntity")));
        if (type != null) {
            Entity entity = type.func_200721_a(worldIn);
            entity.func_70020_e(stack.func_77978_p().func_74775_l("EntityData"));
            return entity;
        }
        return null;
    }

    public void storeEntity(ItemStack stack, LivingEntity livingEntity) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74778_a("StoredEntity", EntityType.func_200718_a((EntityType)livingEntity.func_200600_R()).toString());
        CompoundNBT entityTag = new CompoundNBT();
        livingEntity.func_189511_e(entityTag);
        tag.func_218657_a("EntityData", (INBT)entityTag);
        stack.func_77982_d(tag);
        livingEntity.remove(true);
    }

    public boolean isBlacklisted(LivingEntity livingEntity) {
        return ForceTags.FLASK_BLACKLIST.func_230235_a_((Object)livingEntity.func_200600_R());
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        if (this.hasEntityStored(stack)) {
            return new TranslationTextComponent(super.func_77667_c(stack), new Object[]{stack.func_77978_p().func_74779_i("StoredEntity")});
        }
        return new TranslationTextComponent(super.func_77667_c(stack), new Object[]{"Empty"});
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (this.hasEntityStored(stack)) {
            CompoundNBT tag = stack.func_196082_o();
            tooltip.add((ITextComponent)new TranslationTextComponent("item.entity_flask.tooltip").func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)new StringTextComponent(String.format("[%s]", tag.func_74779_i("StoredEntity"))).func_240699_a_(TextFormatting.GRAY)));
            if (tag.func_74764_b("EntityData")) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.entity_flask.tooltip2").func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)new StringTextComponent(String.format("[%s]", tag.func_74775_l("EntityData").func_74769_h("Health"))).func_240699_a_(TextFormatting.GRAY)));
            }
        }
    }
}

