/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items;

import com.mrbysco.forcecraft.container.SpoilsBagContainer;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.registry.ForceTables;
import com.mrbysco.forcecraft.util.ItemHandlerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class SpoilsBagItem
extends BaseItem {
    private final int tier;

    public SpoilsBagItem(Item.Properties properties, int tier) {
        super(properties.func_200917_a(1));
        this.tier = tier;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        IItemHandler tileInventory;
        World worldIn = context.func_195991_k();
        ItemStack stack = context.func_195996_i();
        this.populateBag(worldIn, stack);
        BlockPos pos = context.func_195995_a();
        Direction face = context.func_196000_l();
        TileEntity tile = worldIn.func_175625_s(pos);
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (handler != null && tile != null && tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face).isPresent() && (tileInventory = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face).orElse(null)) != null && handler instanceof ItemStackHandler) {
            ItemStackHandler itemHandler = (ItemStackHandler)handler;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack bagStack = itemHandler.getStackInSlot(i);
                ItemStack remaining = ItemHandlerHelper.copyStackWithSize((ItemStack)bagStack, (int)bagStack.func_190916_E());
                if (bagStack.func_190926_b()) continue;
                remaining = ItemHandlerHelper.insertItem((IItemHandler)tileInventory, (ItemStack)bagStack, (boolean)false);
                itemHandler.setStackInSlot(i, remaining);
            }
            if (ItemHandlerUtils.isEmpty((IItemHandler)itemHandler)) {
                stack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (handler != null) {
            this.populateBag(worldIn, stack);
            playerIn.func_213829_a(this.getContainer(stack));
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public ResourceLocation getTable() {
        switch (this.tier) {
            default: {
                return ForceTables.TIER_1;
            }
            case 2: {
                return ForceTables.TIER_2;
            }
            case 3: 
        }
        return ForceTables.TIER_3;
    }

    public void populateBag(World worldIn, ItemStack stack) {
        IItemHandler handler;
        if (!worldIn.field_72995_K && !stack.func_196082_o().func_74767_n("Filled") && (handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null)) instanceof ItemStackHandler && ItemHandlerUtils.isEmpty(handler)) {
            List lootStacks;
            CompoundNBT tag = stack.func_196082_o();
            List stacks = new ArrayList();
            do {
                LootContext ctx = new LootContext.Builder((ServerWorld)worldIn).func_216022_a(LootParameterSets.field_216260_a);
                lootStacks = ((ServerWorld)worldIn).func_73046_m().func_200249_aQ().func_186521_a(this.getTable()).func_216113_a(ctx);
                if (lootStacks.isEmpty()) {
                    return;
                }
                Collections.shuffle(lootStacks);
            } while ((stacks = lootStacks).isEmpty());
            if (stacks.size() > 7) {
                int newSize = Math.min(8, Math.max(5, worldIn.field_73012_v.nextInt(stacks.size())));
                if (stacks.size() < newSize) {
                    newSize = stacks.size();
                }
                ArrayList newStacks = new ArrayList();
                for (int i = 0; i < newSize; ++i) {
                    newStacks.add(stacks.get(i));
                }
                stacks = newStacks;
            }
            ItemStackHandler stackhandler = (ItemStackHandler)handler;
            for (int i = 0; i < stacks.size(); ++i) {
                stackhandler.setStackInSlot(i, (ItemStack)stacks.get(i));
            }
            tag.func_74757_a("Filled", true);
            stack.func_77982_d(tag);
        }
    }

    @Nullable
    public INamedContainerProvider getContainer(ItemStack stack) {
        return new SimpleNamedContainerProvider((id, inventory, player) -> new SpoilsBagContainer(id, inventory, stack), (ITextComponent)(stack.func_82837_s() ? ((TextComponent)stack.func_200301_q()).func_240699_a_(TextFormatting.BLACK) : new TranslationTextComponent("forcecraft.container.spoils_bag")));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        IItemHandler handler;
        if (!worldIn.field_72995_K && stack.func_77942_o() && stack.func_77978_p().func_74767_n("Filled") && ItemHandlerUtils.isEmpty(handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null))) {
            stack.func_190918_g(1);
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new StringTextComponent("Tier: " + this.tier).func_240699_a_(TextFormatting.GRAY));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new InventoryProvider();
    }

    private static class InventoryProvider
    implements ICapabilitySerializable<CompoundNBT> {
        private final LazyOptional<ItemStackHandler> inventory = LazyOptional.of(() -> new ItemStackHandler(8){

            public boolean isItemValid(int slot, ItemStack stack) {
                return false;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return stack;
            }
        });

        private InventoryProvider() {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.inventory.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            if (this.inventory.isPresent()) {
                return ((ItemStackHandler)this.inventory.resolve().get()).serializeNBT();
            }
            return new CompoundNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.inventory.ifPresent(h -> h.deserializeNBT(nbt));
        }
    }
}

