/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items;

import com.mrbysco.forcecraft.container.ItemCardContainer;
import com.mrbysco.forcecraft.items.BaseItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class ItemCardItem
extends BaseItem {
    private static final ITextComponent BAD_READ = new StringTextComponent("BAD READ. TRY AGAIN.").func_240699_a_(TextFormatting.RED);
    private static final ITextComponent TOO_SLOW = new StringTextComponent("TOO SLOW. TRY AGAIN.").func_240699_a_(TextFormatting.RED);
    private static final ITextComponent TOO_FAST = new StringTextComponent("TOO FAST. TRY AGAIN.").func_240699_a_(TextFormatting.RED);

    public ItemCardItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (playerIn.func_225608_bj_() && !worldIn.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)this.getContainer(worldIn, playerIn.func_233580_cy_()), (BlockPos)playerIn.func_233580_cy_());
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Nullable
    public INamedContainerProvider getContainer(World worldIn, BlockPos pos) {
        return new SimpleNamedContainerProvider((id, inventory, player) -> new ItemCardContainer(id, inventory, IWorldPosCallable.func_221488_a((World)worldIn, (BlockPos)pos)), (ITextComponent)new TranslationTextComponent("forcecraft.container.card"));
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        World worldIn = playerIn.field_70170_p;
        worldIn.func_184148_a((PlayerEntity)null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_219663_hb, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        if (worldIn.field_72995_K) {
            ITextComponent message;
            int rand = field_77697_d.nextInt(3);
            switch (rand) {
                default: {
                    message = BAD_READ;
                    break;
                }
                case 1: {
                    message = TOO_SLOW;
                    break;
                }
                case 2: {
                    message = TOO_FAST;
                }
            }
            playerIn.func_146105_b(message, true);
        }
        return super.func_111207_a(stack, playerIn, target, hand);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("RecipeContents")) {
            CompoundNBT recipeContents = tag.func_74775_l("RecipeContents");
            ItemStack resultStack = ItemStack.func_199557_a((CompoundNBT)recipeContents.func_74775_l("result"));
            tooltip.add((ITextComponent)new TranslationTextComponent("forcecraft.item_card.recipe_output", new Object[]{new StringTextComponent(resultStack.func_190916_E() + " " + resultStack.func_200301_q().getString()).func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.YELLOW));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("forcecraft.item_card.unset").func_240699_a_(TextFormatting.RED));
        }
        tooltip.add((ITextComponent)new StringTextComponent(" "));
        tooltip.add((ITextComponent)new TranslationTextComponent("forcecraft.item_card.recipe_set").func_240699_a_(TextFormatting.BOLD));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

