/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items;

import com.mrbysco.forcecraft.capablilities.pack.PackInventoryProvider;
import com.mrbysco.forcecraft.capablilities.pack.PackItemStackHandler;
import com.mrbysco.forcecraft.client.gui.pack.RenameAndRecolorScreen;
import com.mrbysco.forcecraft.container.ForcePackContainer;
import com.mrbysco.forcecraft.items.BaseItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ForcePackItem
extends BaseItem {
    public static final String SLOTS_TOTAL = "SlotsTotal";
    public static final String SLOTS_USED = "SlotsUsed";

    public ForcePackItem(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_225608_bj_()) {
            if (worldIn.field_72995_K) {
                RenameAndRecolorScreen.openScreen(stack, handIn);
            }
        } else if (!worldIn.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)this.getContainer(stack), (BlockPos)playerIn.func_233580_cy_());
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Nullable
    public INamedContainerProvider getContainer(ItemStack stack) {
        return new SimpleNamedContainerProvider((id, inventory, player) -> new ForcePackContainer(id, inventory), (ITextComponent)(stack.func_82837_s() ? ((TextComponent)stack.func_200301_q()).func_240699_a_(TextFormatting.BLACK) : new TranslationTextComponent("forcecraft.container.pack")));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int defaultAmount = 8;
        CompoundNBT tag = stack.func_196082_o();
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (handler instanceof PackItemStackHandler) {
            defaultAmount = ((PackItemStackHandler)handler).getSlotsInUse();
        }
        tooltip.add((ITextComponent)new StringTextComponent(String.format("%s/%s Slots", tag.func_74762_e(SLOTS_USED), defaultAmount)));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return ((TextComponent)super.func_200295_i(stack)).func_240699_a_(TextFormatting.YELLOW);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new PackInventoryProvider();
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT shareTag = stack.func_196082_o();
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (handler instanceof PackItemStackHandler) {
            PackItemStackHandler packHandler = (PackItemStackHandler)handler;
            shareTag.func_74768_a("Upgrades", packHandler.getUpgrades());
        }
        return shareTag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (nbt != null && nbt.func_74764_b("Upgrades")) {
            stack.func_196082_o().func_74768_a(SLOTS_USED, nbt.func_74762_e(SLOTS_USED));
            IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
            if (handler instanceof PackItemStackHandler) {
                PackItemStackHandler packHandler = (PackItemStackHandler)handler;
                packHandler.setUpgrades(nbt.func_74762_e("Upgrades"));
            }
        }
        super.readShareTag(stack, nbt);
    }
}

