/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items;

import com.mrbysco.forcecraft.client.gui.pack.RenameAndRecolorScreen;
import com.mrbysco.forcecraft.container.ForceBeltContainer;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.registry.ForceTags;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ForceBeltItem
extends BaseItem {
    public ForceBeltItem(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_225608_bj_()) {
            if (worldIn.field_72995_K) {
                RenameAndRecolorScreen.openScreen(stack, handIn);
            }
        } else if (!worldIn.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)this.getContainer(stack), (BlockPos)playerIn.func_233580_cy_());
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        ItemStack stack = context.func_195996_i();
        if (player != null && !context.func_195991_k().field_72995_K && stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
            player.func_213829_a(this.getContainer(stack));
            return ActionResultType.PASS;
        }
        return super.func_195939_a(context);
    }

    @Nullable
    public INamedContainerProvider getContainer(ItemStack stack) {
        return new SimpleNamedContainerProvider((id, inventory, player) -> new ForceBeltContainer(id, inventory), (ITextComponent)(stack.func_82837_s() ? ((TextComponent)stack.func_200301_q()).func_240699_a_(TextFormatting.BLACK) : new TranslationTextComponent("forcecraft.container.belt")));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("SlotsUsed") && tag.func_74764_b("SlotsTotal")) {
            tooltip.add((ITextComponent)new StringTextComponent(String.format("%s/%s Slots", tag.func_74762_e("SlotsUsed"), tag.func_74762_e("SlotsTotal"))));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent("0/8 Slots"));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return ((TextComponent)super.func_200295_i(stack)).func_240699_a_(TextFormatting.YELLOW);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new InventoryProvider();
    }

    private static class InventoryProvider
    implements ICapabilitySerializable<CompoundNBT> {
        private final LazyOptional<ItemStackHandler> inventory = LazyOptional.of(() -> new ItemStackHandler(8){

            public boolean isItemValid(int slot, ItemStack stack) {
                return !(stack.func_77973_b() instanceof ForceBeltItem) && stack.func_77973_b().func_206844_a(ForceTags.VALID_FORCE_BELT) && super.isItemValid(slot, stack);
            }
        });

        private InventoryProvider() {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.inventory.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            if (this.inventory.isPresent()) {
                return ((ItemStackHandler)this.inventory.resolve().get()).serializeNBT();
            }
            return new CompoundNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.inventory.ifPresent(h -> h.deserializeNBT(nbt));
        }
    }
}

