/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items;

import com.mrbysco.forcecraft.capablilities.CapabilityHandler;
import com.mrbysco.forcecraft.capablilities.experiencetome.ExperienceTomeProvider;
import com.mrbysco.forcecraft.util.ForceUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ExperienceTomeItem
extends Item {
    public static final int CAPACITY = Integer.MAX_VALUE;

    public ExperienceTomeItem(Item.Properties properties) {
        super(properties);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("forcecraft.tooltip.press_shift"));
            return;
        }
        tooltip.add((ITextComponent)new StringTextComponent(Float.toString(ExperienceTomeItem.getExperience(stack)) + " / " + Float.toString(ExperienceTomeItem.getMaxExperience(stack))));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (CapabilityHandler.CAPABILITY_EXPTOME == null) {
            return null;
        }
        return new ExperienceTomeProvider();
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (ForceUtils.isFakePlayer((Entity)player) || hand != Hand.MAIN_HAND || world.field_72995_K) {
            return new ActionResult(ActionResultType.FAIL, (Object)stack);
        }
        int curLevel = player.field_71068_ca;
        if (player.func_225608_bj_()) {
            int exp = ExperienceTomeItem.getExtraPlayerExperience(player) > 0 ? Math.min(ExperienceTomeItem.getTotalExpForLevel(player.field_71068_ca + 1) - ExperienceTomeItem.getTotalExpForLevel(player.field_71068_ca) - ExperienceTomeItem.getExtraPlayerExperience(player), ExperienceTomeItem.getExperience(stack)) : Math.min(ExperienceTomeItem.getTotalExpForLevel(player.field_71068_ca + 1) - ExperienceTomeItem.getTotalExpForLevel(player.field_71068_ca), ExperienceTomeItem.getExperience(stack));
            ExperienceTomeItem.setPlayerExperience(player, ExperienceTomeItem.getPlayerExperience(player) + exp);
            if (player.field_71068_ca < curLevel + 1 && ExperienceTomeItem.getPlayerExperience(player) >= ExperienceTomeItem.getTotalExpForLevel(curLevel + 1)) {
                ExperienceTomeItem.setPlayerLevel(player, curLevel + 1);
            }
            ExperienceTomeItem.modifyExperience(stack, -exp);
        } else if (ExperienceTomeItem.getExtraPlayerExperience(player) > 0) {
            int exp = Math.min(ExperienceTomeItem.getExtraPlayerExperience(player), ExperienceTomeItem.getSpace(stack));
            ExperienceTomeItem.setPlayerExperience(player, ExperienceTomeItem.getPlayerExperience(player) - exp);
            if (player.field_71068_ca < curLevel) {
                ExperienceTomeItem.setPlayerLevel(player, curLevel);
            }
            ExperienceTomeItem.modifyExperience(stack, exp);
        } else if (player.field_71068_ca > 0) {
            int exp = Math.min(ExperienceTomeItem.getTotalExpForLevel(player.field_71068_ca) - ExperienceTomeItem.getTotalExpForLevel(player.field_71068_ca - 1), ExperienceTomeItem.getSpace(stack));
            ExperienceTomeItem.setPlayerExperience(player, ExperienceTomeItem.getPlayerExperience(player) - exp);
            if (player.field_71068_ca < curLevel - 1) {
                ExperienceTomeItem.setPlayerLevel(player, curLevel - 1);
            }
            ExperienceTomeItem.modifyExperience(stack, exp);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)stack);
    }

    public static int getPlayerExperience(PlayerEntity player) {
        return ExperienceTomeItem.getTotalExpForLevel(player.field_71068_ca) + ExperienceTomeItem.getExtraPlayerExperience(player);
    }

    public static int getLevelPlayerExperience(PlayerEntity player) {
        return ExperienceTomeItem.getTotalExpForLevel(player.field_71068_ca);
    }

    public static int getExtraPlayerExperience(PlayerEntity player) {
        return Math.round(player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void setPlayerExperience(PlayerEntity player, int exp) {
        player.field_71068_ca = 0;
        player.field_71106_cc = 0.0f;
        player.field_71067_cb = 0;
        ExperienceTomeItem.addExperienceToPlayer(player, exp);
    }

    public static void setPlayerLevel(PlayerEntity player, int level) {
        player.field_71068_ca = level;
        player.field_71106_cc = 0.0f;
    }

    public static void addExperienceToPlayer(PlayerEntity player, int exp) {
        int i = Integer.MAX_VALUE - player.field_71067_cb;
        if (exp > i) {
            exp = i;
        }
        player.field_71106_cc += (float)exp / (float)player.func_71050_bK();
        player.field_71067_cb += exp;
        while (player.field_71106_cc >= 1.0f) {
            player.field_71106_cc = (player.field_71106_cc - 1.0f) * (float)player.func_71050_bK();
            ExperienceTomeItem.addExperienceLevelToPlayer(player, 1);
            player.field_71106_cc /= (float)player.func_71050_bK();
        }
    }

    public static void addExperienceLevelToPlayer(PlayerEntity player, int levels) {
        player.field_71068_ca += levels;
        if (player.field_71068_ca < 0) {
            player.field_71068_ca = 0;
            player.field_71106_cc = 0.0f;
            player.field_71067_cb = 0;
        }
    }

    public static int getTotalExpForLevel(int level) {
        return level >= 32 ? (9 * level * level - 325 * level + 4440) / 2 : (level >= 17 ? (5 * level * level - 81 * level + 720) / 2 : level * level + 6 * level);
    }

    public static int modifyExperience(ItemStack stack, int exp) {
        int storedExp = ExperienceTomeItem.getExperience(stack) + exp;
        if (storedExp > ExperienceTomeItem.getMaxExperience(stack)) {
            storedExp = ExperienceTomeItem.getMaxExperience(stack);
        } else if (storedExp < 0) {
            storedExp = 0;
        }
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74768_a("Experience", storedExp);
        stack.func_77982_d(tag);
        return storedExp;
    }

    public static int getExperience(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        return stack.func_77978_p().func_74762_e("Experience");
    }

    public static int getMaxExperience(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public static int getSpace(ItemStack stack) {
        return ExperienceTomeItem.getMaxExperience(stack) - ExperienceTomeItem.getExperience(stack);
    }
}

