/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items;

import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.util.ItemHandlerUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class BaconatorItem
extends BaseItem {
    public static final String HAS_FOOD_TAG = "forcecraft:hasItems";

    public BaconatorItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack firstStack;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        IItemHandler handler = (IItemHandler)itemstack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (playerIn.func_225608_bj_()) {
            boolean isFull = ItemHandlerUtils.isFull(handler);
            if (!isFull) {
                boolean extracted = ItemHandlerUtils.extractStackFromPlayer(playerIn.field_71071_by, handler, stack -> {
                    ITagCollectionSupplier tagCollection = TagCollectionManager.func_242178_a();
                    ResourceLocation baconatorFood = new ResourceLocation("forcecraft", "baconator_food");
                    Tag tag = (Tag)tagCollection.func_241836_b().func_199910_a(baconatorFood);
                    return !stack.func_190926_b() && stack.func_222117_E() && tag != null && stack.func_77973_b().func_206844_a((ITag)tag);
                });
                boolean hasItems = ItemHandlerUtils.hasItems(handler);
                if (!extracted) {
                    if (hasItems) {
                        itemstack.func_196085_b(itemstack.func_77952_i() == 1 ? 0 : 1);
                    }
                } else {
                    worldIn.func_184148_a((PlayerEntity)null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                CompoundNBT tag = itemstack.func_196082_o();
                tag.func_74757_a(HAS_FOOD_TAG, hasItems);
            }
        } else if (ItemHandlerUtils.hasItems(handler) && !(firstStack = ItemHandlerUtils.getFirstItem(handler)).func_190926_b() && playerIn.func_71043_e(firstStack.func_77973_b().func_219967_s().func_221468_d())) {
            playerIn.func_184598_c(handIn);
        }
        return ActionResult.func_226250_c_((Object)itemstack);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        ItemStack firstStack = ItemHandlerUtils.getFirstItem(handler);
        if (firstStack != null && !firstStack.func_190926_b()) {
            entityLiving.func_213357_a(worldIn, firstStack);
            worldIn.func_184148_a((PlayerEntity)null, entityLiving.func_226277_ct_(), entityLiving.func_226278_cu_(), entityLiving.func_226281_cx_(), SoundEvents.field_187697_dL, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        return stack;
    }

    public UseAction func_77661_b(ItemStack stack) {
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        ItemStack firstStack = ItemHandlerUtils.getFirstItem(handler);
        return firstStack != null && firstStack.func_77973_b().func_219971_r() ? UseAction.EAT : UseAction.NONE;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77952_i() == 1 && entityIn instanceof PlayerEntity && worldIn.func_82737_E() % 20L == 0L) {
            IItemHandler handler;
            ItemStack firstStack;
            PlayerEntity playerIn = (PlayerEntity)entityIn;
            if (!playerIn.field_71075_bZ.field_75098_d && playerIn.func_71043_e(false) && stack.func_196082_o().func_74767_n(HAS_FOOD_TAG) && !(firstStack = ItemHandlerUtils.getFirstItem(handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null))).func_190926_b()) {
                playerIn.func_213357_a(worldIn, firstStack);
                worldIn.func_184148_a((PlayerEntity)null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187697_dL, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        ItemStack firstStack = ItemHandlerUtils.getFirstItem(handler);
        if (!firstStack.func_190926_b() && firstStack.func_77973_b().func_219971_r()) {
            return firstStack.func_77973_b().func_219967_s().func_221465_e() ? 16 : 32;
        }
        return 0;
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77952_i() == 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("forcecraft.baconator.shift.carrying").func_240699_a_(TextFormatting.DARK_RED));
            IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
            if (handler != null) {
                int stacks = 0;
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack foodStack = handler.getStackInSlot(i);
                    if (foodStack.func_190926_b()) continue;
                    tooltip.add((ITextComponent)new StringTextComponent(foodStack.func_190916_E() + "x ").func_230529_a_(foodStack.func_200301_q()).func_240699_a_(TextFormatting.GOLD));
                    ++stacks;
                }
                if (stacks == 0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("forcecraft.baconator.shift.nothing").func_240699_a_(TextFormatting.GRAY));
                }
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("forcecraft.baconator.shift.text").func_240699_a_(TextFormatting.GRAY));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new InventoryProvider();
    }

    private static class InventoryProvider
    implements ICapabilitySerializable<CompoundNBT> {
        private final LazyOptional<ItemStackHandler> inventory = LazyOptional.of(() -> new ItemStackHandler((Integer)ConfigHandler.COMMON.baconatorMaxStacks.get()){

            public boolean isItemValid(int slot, ItemStack stack) {
                ITagCollectionSupplier tagCollection = TagCollectionManager.func_242178_a();
                ResourceLocation baconatorFood = new ResourceLocation("forcecraft", "baconator_food");
                Tag tag = (Tag)tagCollection.func_241836_b().func_199910_a(baconatorFood);
                return stack.func_222117_E() && tag != null && stack.func_77973_b().func_206844_a((ITag)tag);
            }
        });

        private InventoryProvider() {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.inventory.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            if (this.inventory.isPresent()) {
                return ((ItemStackHandler)this.inventory.resolve().get()).serializeNBT();
            }
            return new CompoundNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.inventory.ifPresent(h -> h.deserializeNBT(nbt));
        }
    }
}

