/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.handlers;

import com.mrbysco.forcecraft.capablilities.CapabilityHandler;
import com.mrbysco.forcecraft.capablilities.playermodifier.IPlayerModifier;
import com.mrbysco.forcecraft.capablilities.toolmodifier.IToolModifier;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.registry.ForceSounds;
import com.mrbysco.forcecraft.util.MobUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.CreeperSwellGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ToolModifierHandler {
    @SubscribeEvent
    public void onLivingDamageEvent(LivingDamageEvent event) {
        PlayerEntity player;
        if (event.getSource() == null) {
            return;
        }
        DamageSource source = event.getSource();
        LivingEntity target = event.getEntityLiving();
        Entity trueSource = source.func_76346_g();
        if (trueSource instanceof PlayerEntity) {
            player = (PlayerEntity)source.func_76346_g();
            boolean appliedBane = false;
            int bleedLevel = 0;
            IToolModifier toolCap = (IToolModifier)player.func_184614_ca().getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (toolCap != null) {
                if (toolCap.hasBane()) {
                    this.applyBane(target);
                    appliedBane = true;
                }
                if (toolCap.hasBleed()) {
                    bleedLevel = toolCap.getBleedLevel();
                }
            }
            MobUtil.addBleedingEffect(bleedLevel, target, (Entity)player);
            IPlayerModifier playerCap = (IPlayerModifier)player.getCapability(CapabilityHandler.CAPABILITY_PLAYERMOD).orElse(null);
            if (playerCap != null) {
                if (playerCap.hasBane() && !appliedBane) {
                    this.applyBane(target);
                }
                float damage = event.getAmount();
                if (playerCap.hasHeatDamage()) {
                    damage = playerCap.getAttackDamage() == 0.0f ? (damage += playerCap.getHeatDamage()) : (damage += playerCap.getAttackDamage());
                    target.func_241209_g_(30 * playerCap.getHeatPieces());
                } else {
                    damage += playerCap.getAttackDamage();
                }
                if (playerCap.getAttackDamage() > 0.0f && player.func_184614_ca().func_190926_b()) {
                    player.field_70170_p.func_184148_a((PlayerEntity)null, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), (SoundEvent)ForceSounds.FORCE_PUNCH.get(), player.func_184176_by(), 1.0f, 1.0f);
                    event.setAmount(damage);
                }
            }
        }
        if (target instanceof PlayerEntity) {
            player = (PlayerEntity)target;
            int sturdyLevel = 0;
            for (ItemStack armorStack : player.func_184193_aE()) {
                IToolModifier modifierCap = (IToolModifier)armorStack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
                if (modifierCap == null || !modifierCap.hasSturdy()) continue;
                ++sturdyLevel;
            }
            if (sturdyLevel > 0) {
                double perArmor = (Double)ConfigHandler.COMMON.sturdyDamageReduction.get();
                double percentage = (double)sturdyLevel * (perArmor / 4.0);
                float oldDamage = event.getAmount();
                float newDamage = (float)((double)oldDamage - (double)oldDamage * percentage);
                event.setAmount(MathHelper.func_76131_a((float)newDamage, (float)1.0f, (float)Float.MAX_VALUE));
            }
        }
    }

    private void applyBane(LivingEntity target) {
        if (target instanceof CreeperEntity) {
            CreeperEntity creeper = (CreeperEntity)target;
            creeper.getCapability(CapabilityHandler.CAPABILITY_BANE).ifPresent(entityCap -> {
                if (entityCap.canExplode()) {
                    creeper.func_70829_a(-1);
                    creeper.func_184212_Q().func_187227_b(CreeperEntity.field_184715_c, (Object)false);
                    entityCap.setExplodeAbility(false);
                    creeper.field_70714_bg.field_220892_d.removeIf(goal -> goal.func_220772_j() instanceof CreeperSwellGoal);
                }
            });
        }
        if (target instanceof EndermanEntity) {
            EndermanEntity enderman = (EndermanEntity)target;
            enderman.getCapability(CapabilityHandler.CAPABILITY_BANE).ifPresent(entityCap -> {
                if (entityCap.canTeleport()) {
                    entityCap.setTeleportAbility(false);
                }
            });
        }
    }
}

