/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.handlers;

import com.mrbysco.forcecraft.capablilities.CapabilityHandler;
import com.mrbysco.forcecraft.capablilities.toolmodifier.IToolModifier;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.items.ForceArmorItem;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerCapHandler {
    private static final int SPEED_DURATION = 200;

    @SubscribeEvent
    public void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.field_70170_p.field_72995_K) {
            PlayerEntity player = event.player;
            Iterable armor = player.func_184193_aE();
            int speed = 0;
            for (ItemStack slotSelected : armor) {
                IToolModifier modifierCap;
                if (!(slotSelected.func_77973_b() instanceof ForceArmorItem) || (modifierCap = (IToolModifier)slotSelected.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) == null) continue;
                speed += modifierCap.getSpeedLevel();
            }
            if (speed > 0) {
                EffectInstance speedEffect = new EffectInstance(Effects.field_76424_c, 200, speed - 1, false, false);
                if (!player.func_70644_a(Effects.field_76424_c) || player.func_70644_a(Effects.field_76424_c) && player.func_70660_b(Effects.field_76424_c).func_76459_b() <= 100) {
                    player.func_195064_c(speedEffect);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            PlayerCapHandler.updateArmorProperties(player);
        }
    }

    @SubscribeEvent
    public void equipmentChangeEvent(LivingEquipmentChangeEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            PlayerCapHandler.updateArmorProperties(player);
        }
    }

    public static void updateArmorProperties(PlayerEntity player) {
        Iterable armor = player.func_184193_aE();
        int armorPieces = 0;
        int damage = 0;
        int heat = 0;
        int luck = 0;
        int bane = 0;
        int bleed = 0;
        for (ItemStack slotSelected : armor) {
            IToolModifier modifierCap;
            if (!(slotSelected.func_77973_b() instanceof ForceArmorItem) || (modifierCap = (IToolModifier)slotSelected.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) == null) continue;
            ++armorPieces;
            damage += (int)((double)modifierCap.getSharpLevel() * (Double)ConfigHandler.COMMON.forcePunchDamage.get());
            if (modifierCap.hasHeat()) {
                ++heat;
            }
            if (modifierCap.hasLuck()) {
                ++luck;
            }
            if (modifierCap.hasBane()) {
                ++bane;
            }
            if (!modifierCap.hasBleed()) continue;
            bleed += modifierCap.getBleedLevel();
        }
        int finalArmorPieces = armorPieces;
        player.getCapability(CapabilityHandler.CAPABILITY_PLAYERMOD).ifPresent(cap -> cap.setArmorPieces(finalArmorPieces));
        int finalDamage = damage;
        player.getCapability(CapabilityHandler.CAPABILITY_PLAYERMOD).ifPresent(cap -> cap.setAttackDamage(1.0f * (float)finalDamage));
        int finalHeat = heat;
        player.getCapability(CapabilityHandler.CAPABILITY_PLAYERMOD).ifPresent(cap -> {
            cap.setHeatPieces(finalHeat);
            cap.setHeatDamage(2.0f * (float)finalHeat);
        });
        int finalLuck = luck;
        player.getCapability(CapabilityHandler.CAPABILITY_PLAYERMOD).ifPresent(cap -> cap.setLuckLevel(finalLuck));
        int finalBane = bane;
        player.getCapability(CapabilityHandler.CAPABILITY_PLAYERMOD).ifPresent(cap -> cap.setBane(finalBane > 0));
        int finalBleed = bleed;
        player.getCapability(CapabilityHandler.CAPABILITY_PLAYERMOD).ifPresent(cap -> cap.setBleeding(finalBleed));
    }

    @SubscribeEvent
    public void harvestCheckEvent(PlayerEvent.HarvestCheck event) {
        PlayerEntity player = event.getPlayer();
        player.getCapability(CapabilityHandler.CAPABILITY_PLAYERMOD).ifPresent(cap -> {
            if (cap.hasFullSet() && player.func_184614_ca().func_190926_b() && event.getTargetBlock().func_177230_c().getHarvestLevel(event.getTargetBlock()) <= 2) {
                event.setCanHarvest(true);
            }
        });
    }

    @SubscribeEvent
    public void breakSpeedEvent(PlayerEvent.BreakSpeed event) {
        PlayerEntity player = event.getPlayer();
        player.getCapability(CapabilityHandler.CAPABILITY_PLAYERMOD).ifPresent(cap -> {
            if (cap.hasFullSet() && player.func_184614_ca().func_190926_b() && event.getOriginalSpeed() < 6.0f) {
                event.setNewSpeed(6.0f);
            }
        });
    }
}

