/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.handlers;

import com.mrbysco.forcecraft.capablilities.CapabilityHandler;
import com.mrbysco.forcecraft.capablilities.playermodifier.IPlayerModifier;
import com.mrbysco.forcecraft.entities.projectile.ForceArrowEntity;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class LootingHandler {
    @SubscribeEvent
    public void onLooting(LootingLevelEvent event) {
        DamageSource source = event.getDamageSource();
        if (source == null || source.func_76346_g() == null) {
            return;
        }
        int level = event.getLootingLevel();
        IPlayerModifier playerModifier = (IPlayerModifier)source.func_76346_g().getCapability(CapabilityHandler.CAPABILITY_PLAYERMOD).orElse(null);
        int customLevel = 0;
        if (playerModifier != null) {
            customLevel += playerModifier.getLuckLevel();
        }
        if (source.func_76364_f() instanceof ForceArrowEntity) {
            ForceArrowEntity forceArrow = (ForceArrowEntity)source.func_76364_f();
            customLevel += forceArrow.getLuck();
        }
        if (customLevel > 4) {
            customLevel = 4;
        }
        event.setLootingLevel(level += customLevel);
    }

    @SubscribeEvent
    public void onTreasureDrop(LivingDropsEvent event) {
        if (event.getSource() == null || event.getSource().func_76346_g() == null) {
            return;
        }
        Entity source = event.getSource().func_76346_g();
        if (source instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)source;
            player.func_184614_ca().getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).ifPresent(cap -> {
                if (cap.hasTreasure()) {
                    float dropChance;
                    Random rand = player.func_70681_au();
                    int looting = event.getLootingLevel();
                    LivingEntity entity = event.getEntityLiving();
                    BlockPos entityPos = entity.func_233580_cy_();
                    int chanceMax = 20;
                    if (looting > 0 && (chanceMax /= looting) < 0) {
                        chanceMax = 1;
                    }
                    if ((dropChance = (float)rand.nextInt(chanceMax)) == 0.0f) {
                        if (entity.func_70662_br()) {
                            event.getDrops().add(new ItemEntity(entity.field_70170_p, (double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p(), new ItemStack((IItemProvider)ForceRegistry.UNDEATH_CARD.get(), rand.nextInt(Math.max(1, looting)) + 1)));
                        } else if (entity instanceof MonsterEntity) {
                            event.getDrops().add(new ItemEntity(entity.field_70170_p, (double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p(), new ItemStack((IItemProvider)ForceRegistry.DARKNESS_CARD.get(), rand.nextInt(Math.max(1, looting)) + 1)));
                        } else {
                            event.getDrops().add(new ItemEntity(entity.field_70170_p, (double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p(), new ItemStack((IItemProvider)ForceRegistry.LIFE_CARD.get(), rand.nextInt(Math.max(1, looting)) + 1)));
                        }
                    }
                }
            });
        }
    }
}

