/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.entities.projectile;

import com.mrbysco.forcecraft.ForceCraft;
import com.mrbysco.forcecraft.capablilities.CapabilityHandler;
import com.mrbysco.forcecraft.registry.ForceEntities;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.util.ForceUtils;
import com.mrbysco.forcecraft.util.MobUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.CreeperSwellGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class ForceArrowEntity
extends ArrowEntity {
    private static final DataParameter<Boolean> ENDER = EntityDataManager.func_187226_a(ForceArrowEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> BANE = EntityDataManager.func_187226_a(ForceArrowEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SPEED = EntityDataManager.func_187226_a(ForceArrowEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> GLOWING = EntityDataManager.func_187226_a(ForceArrowEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> LUCK = EntityDataManager.func_187226_a(ForceArrowEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BLEEDING = EntityDataManager.func_187226_a(ForceArrowEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public ForceArrowEntity(EntityType<? extends ArrowEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public ForceArrowEntity(World worldIn, LivingEntity shooter) {
        super(worldIn, shooter);
        this.func_212361_a((Entity)shooter);
    }

    public void func_234612_a_(Entity projectile, float x, float y, float z, float velocity, float inaccuracy) {
        float newVelocity = this.isSpeedy() ? velocity + 1.0f : velocity;
        super.func_234612_a_(projectile, x, y, z, newVelocity, inaccuracy);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ENDER, (Object)false);
        this.field_70180_af.func_187214_a(BANE, (Object)false);
        this.field_70180_af.func_187214_a(LUCK, (Object)0);
        this.field_70180_af.func_187214_a(BLEEDING, (Object)0);
        this.field_70180_af.func_187214_a(SPEED, (Object)false);
        this.field_70180_af.func_187214_a(GLOWING, (Object)false);
    }

    public boolean isBane() {
        return (Boolean)this.field_70180_af.func_187225_a(BANE);
    }

    public void setBane() {
        this.field_70180_af.func_187227_b(BANE, (Object)true);
    }

    public boolean isSpeedy() {
        return (Boolean)this.field_70180_af.func_187225_a(SPEED);
    }

    public void setSpeedy() {
        this.field_70180_af.func_187227_b(SPEED, (Object)true);
    }

    public boolean isEnder() {
        return (Boolean)this.field_70180_af.func_187225_a(ENDER);
    }

    public void setEnder() {
        this.field_70180_af.func_187227_b(ENDER, (Object)true);
    }

    public boolean appliesGlowing() {
        return (Boolean)this.field_70180_af.func_187225_a(GLOWING);
    }

    public void setAppliesGlowing() {
        this.field_70180_af.func_187227_b(GLOWING, (Object)true);
    }

    public int getLuck() {
        return (Integer)this.field_70180_af.func_187225_a(LUCK);
    }

    public void setLuck(int luck) {
        this.field_70180_af.func_187227_b(LUCK, (Object)luck);
    }

    public int getBleeding() {
        return (Integer)this.field_70180_af.func_187225_a(BLEEDING);
    }

    public void setBleeding(int bleeding) {
        this.field_70180_af.func_187227_b(BLEEDING, (Object)bleeding);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74767_n("Bane")) {
            this.setBane();
        }
        if (compound.func_74767_n("Ender")) {
            this.setEnder();
        }
        if (compound.func_74767_n("AppliesGlowing")) {
            this.setAppliesGlowing();
        }
        if (compound.func_74767_n("Speedy")) {
            this.setSpeedy();
        }
        this.setLuck(compound.func_74762_e("Luck"));
        this.setBleeding(compound.func_74762_e("Bleeding"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.isBane()) {
            compound.func_74757_a("Bane", true);
        }
        if (this.isEnder()) {
            compound.func_74757_a("Ender", true);
        }
        if (this.appliesGlowing()) {
            compound.func_74757_a("AppliesGlowing", true);
        }
        if (this.isSpeedy()) {
            compound.func_74757_a("Speedy", true);
        }
        compound.func_74768_a("Luck", this.getLuck());
        compound.func_74768_a("Bleeding", this.getBleeding());
    }

    public void func_184555_a(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151032_g) {
            this.field_184560_g = Potions.field_185229_a;
            this.field_184561_h.clear();
            this.field_70180_af.func_187227_b(field_184559_f, (Object)-1);
        }
    }

    protected void func_184548_a(LivingEntity living) {
        super.func_184548_a(living);
        if (this.isEnder()) {
            ForceUtils.teleportRandomly(living);
        }
        if (this.appliesGlowing()) {
            living.func_195064_c(new EffectInstance(Effects.field_188423_x, 200, 0));
        }
        if (this.getBleeding() > 0) {
            MobUtil.addBleedingEffect(this.getBleeding(), living, this.func_234616_v_());
        }
        if (this.isBane() && living instanceof CreeperEntity) {
            CreeperEntity creeper = (CreeperEntity)living;
            creeper.getCapability(CapabilityHandler.CAPABILITY_BANE).ifPresent(entityCap -> {
                if (entityCap.canExplode()) {
                    creeper.func_70829_a(-1);
                    creeper.func_184212_Q().func_187227_b(CreeperEntity.field_184715_c, (Object)false);
                    entityCap.setExplodeAbility(false);
                    creeper.field_70714_bg.field_220892_d.removeIf(goal -> goal.func_220772_j() instanceof CreeperSwellGoal);
                    ForceCraft.LOGGER.debug("Added Bane to " + living.func_200200_C_());
                }
            });
        }
    }

    protected ItemStack func_184550_j() {
        return new ItemStack((IItemProvider)ForceRegistry.FORCE_ARROW.get());
    }

    public EntityType<?> func_200600_R() {
        return (EntityType)ForceEntities.FORCE_ARROW.get();
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

