/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.entities.goal;

import com.mrbysco.forcecraft.entities.IColdMob;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EatGrassToRestoreGoal
extends Goal {
    private static final Predicate<BlockState> IS_GRASS = BlockStateMatcher.func_177638_a((Block)Blocks.field_150349_c);
    private final MobEntity grassEaterEntity;
    private final World entityWorld;
    private int eatingGrassTimer;

    public EatGrassToRestoreGoal(MobEntity grassEaterEntityIn) {
        this.grassEaterEntity = grassEaterEntityIn;
        this.entityWorld = grassEaterEntityIn.field_70170_p;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean func_75250_a() {
        if (this.grassEaterEntity.func_70681_au().nextInt(this.grassEaterEntity.func_70631_g_() ? 50 : 1000) != 0) {
            return false;
        }
        BlockPos blockpos = this.grassEaterEntity.func_233580_cy_();
        if (IS_GRASS.test(this.entityWorld.func_180495_p(blockpos))) {
            return true;
        }
        return this.entityWorld.func_180495_p(blockpos.func_177977_b()).func_203425_a(Blocks.field_196658_i);
    }

    public void func_75249_e() {
        this.eatingGrassTimer = 40;
        this.entityWorld.func_72960_a((Entity)this.grassEaterEntity, (byte)10);
        this.grassEaterEntity.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        this.eatingGrassTimer = 0;
    }

    public boolean func_75253_b() {
        return this.eatingGrassTimer > 0;
    }

    public int getEatingGrassTimer() {
        return this.eatingGrassTimer;
    }

    public void func_75246_d() {
        this.eatingGrassTimer = Math.max(0, this.eatingGrassTimer - 1);
        if (this.getEatingGrassTimer() == 4) {
            BlockPos blockpos = this.grassEaterEntity.func_233580_cy_();
            if (IS_GRASS.test(this.entityWorld.func_180495_p(blockpos))) {
                if (ForgeEventFactory.getMobGriefingEvent((World)this.entityWorld, (Entity)this.grassEaterEntity)) {
                    this.entityWorld.func_175655_b(blockpos, false);
                }
                this.transformMob();
            } else {
                BlockPos blockpos1 = blockpos.func_177977_b();
                if (this.entityWorld.func_180495_p(blockpos1).func_203425_a(Blocks.field_196658_i)) {
                    if (ForgeEventFactory.getMobGriefingEvent((World)this.entityWorld, (Entity)this.grassEaterEntity)) {
                        this.entityWorld.func_217379_c(2001, blockpos1, Block.func_196246_j((BlockState)Blocks.field_196658_i.func_176223_P()));
                        this.entityWorld.func_180501_a(blockpos1, Blocks.field_150346_d.func_176223_P(), 2);
                    }
                    this.transformMob();
                }
            }
        }
    }

    public void transformMob() {
        if (this.grassEaterEntity instanceof IColdMob) {
            IColdMob coldMob = (IColdMob)this.grassEaterEntity;
            coldMob.transformMob((LivingEntity)this.grassEaterEntity, this.entityWorld);
        }
    }
}

