/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.entities;

import com.mrbysco.forcecraft.registry.ForceSounds;
import java.util.EnumSet;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class FairyEntity
extends CreatureEntity
implements IFlyingAnimal {
    public FairyEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 20, true);
        this.field_70749_g = new LookHelperController((MobEntity)this);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 16.0f);
        this.func_184644_a(PathNodeType.COCOA, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, -1.0f);
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_180495_p(pos).func_196958_f() ? 10.0f : 0.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(8, (Goal)new WanderGoal());
        this.field_70714_bg.func_75776_a(9, (Goal)new SwimGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute generateAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 1.0).func_233815_a_(Attributes.field_233822_e_, (double)0.6f).func_233815_a_(Attributes.field_233821_d_, (double)0.3f);
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public void func_70100_b_(PlayerEntity playerEntity) {
        this.func_184185_a(this.collideSound(playerEntity), 1.0f, 1.0f);
        playerEntity.func_70691_i(Float.MAX_VALUE);
        this.func_70106_y();
    }

    public static boolean canSpawnOn(EntityType<? extends MobEntity> typeIn, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        BlockPos blockpos = pos.func_177977_b();
        return reason == SpawnReason.SPAWNER || worldIn.func_180495_p(blockpos).func_215688_a((IBlockReader)worldIn, blockpos, typeIn) && worldIn.func_226659_b_(pos, 0) > 8;
    }

    public SoundEvent collideSound(PlayerEntity playerEntity) {
        int randomInt = this.field_70170_p.field_73012_v.nextInt(100);
        if (UUID.fromString("7135da42-d327-47bb-bb04-5ba4e212fb32").equals(playerEntity.func_110124_au())) {
            return (SoundEvent)ForceSounds.FAIRY_PICKUP.get();
        }
        if (randomInt <= 1 && UUID.fromString("10755ea6-9721-467a-8b5c-92adf689072c").equals(playerEntity.func_110124_au())) {
            return (SoundEvent)ForceSounds.FAIRY_LISTEN_SPECIAL.get();
        }
        if (randomInt <= 10) {
            return (SoundEvent)ForceSounds.FAIRY_LISTEN.get();
        }
        return (SoundEvent)ForceSounds.FAIRY_PICKUP.get();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70146_Z.nextFloat() < 0.05f && this.func_213322_ci() != Vector3d.field_186680_a) {
            for (int i = 0; i < this.field_70146_Z.nextInt(2) + 1; ++i) {
                this.addParticle(this.field_70170_p, this.func_226277_ct_() - (double)0.3f, this.func_226277_ct_() + (double)0.3f, this.func_226281_cx_() - (double)0.3f, this.func_226281_cx_() + (double)0.3f, this.func_226283_e_(0.5), (IParticleData)ParticleTypes.field_197598_I);
            }
        }
    }

    private void addParticle(World worldIn, double posX, double posX2, double posZ, double posZ2, double posY, IParticleData particleData) {
        worldIn.func_195594_a(particleData, MathHelper.func_219803_d((double)worldIn.field_73012_v.nextDouble(), (double)posX, (double)posX2), posY - (double)0.2f, MathHelper.func_219803_d((double)worldIn.field_73012_v.nextDouble(), (double)posZ, (double)posZ2), 0.0, 0.0, 0.0);
    }

    class WanderGoal
    extends Goal {
        WanderGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return FairyEntity.this.field_70699_by.func_75500_f() && FairyEntity.this.field_70146_Z.nextInt(10) == 0;
        }

        public boolean func_75253_b() {
            return FairyEntity.this.field_70699_by.func_226337_n_();
        }

        public void func_75249_e() {
            Vector3d vector3d = this.getRandomLocation();
            if (vector3d != null) {
                FairyEntity.this.field_70699_by.func_75484_a(FairyEntity.this.field_70699_by.func_179680_a(new BlockPos(vector3d), 1), 1.0);
            }
        }

        @Nullable
        private Vector3d getRandomLocation() {
            Vector3d vector3d = FairyEntity.this.func_70676_i(0.0f);
            Vector3d vector3d2 = RandomPositionGenerator.func_226340_a_((CreatureEntity)FairyEntity.this, (int)8, (int)7, (Vector3d)vector3d, (float)1.5707964f, (int)2, (int)1);
            return vector3d2 != null ? vector3d2 : RandomPositionGenerator.func_226338_a_((CreatureEntity)FairyEntity.this, (int)8, (int)4, (int)-2, (Vector3d)vector3d, (double)1.5707963705062866);
        }
    }

    static class LookHelperController
    extends LookController {
        public LookHelperController(MobEntity entityIn) {
            super(entityIn);
        }

        public void func_75649_a() {
        }
    }
}

