/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.entities;

import com.mrbysco.forcecraft.entities.AngryEndermanEntity;
import com.mrbysco.forcecraft.registry.ForceEntities;
import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class EnderTotEntity
extends EndermanEntity {
    private static final ResourceLocation TOT_HOLDABLE = new ResourceLocation("forcecraft", "endertot_holdable");

    public EnderTotEntity(EntityType<? extends EndermanEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 8.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new StareGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(10, (Goal)new PlaceBlockGoal(this));
        this.field_70714_bg.func_75776_a(11, (Goal)new TakeBlockGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new FindPlayerGoal(this, arg_0 -> ((EnderTotEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EndermiteEntity.class, 10, true, false, field_213627_bA));
        this.field_70715_bh.func_75776_a(4, (Goal)new ResetAngerGoal((MobEntity)this, false));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.35f;
    }

    public boolean func_70631_g_() {
        return true;
    }

    public boolean func_70820_n() {
        if (!this.field_70170_p.func_201670_d() && this.func_70089_S() && !this.func_203005_aq()) {
            double d0 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 32.0;
            double d1 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(32) - 16);
            double d2 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 32.0;
            return this.func_70825_j(d0, d1, d2);
        }
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        Entity entitySource = cause.func_76364_f();
        if (entitySource instanceof LivingEntity && !this.field_70170_p.field_72995_K) {
            LivingEntity livingEntity = (LivingEntity)entitySource;
            int total = this.func_70681_au().nextInt(2) + 1;
            for (int i = 0; i < total; ++i) {
                AngryEndermanEntity endermanEntity = (AngryEndermanEntity)((EntityType)ForceEntities.ANGRY_ENDERMAN.get()).func_200721_a(this.field_70170_p);
                endermanEntity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), 0.0f, 0.0f);
                endermanEntity.func_70624_b(livingEntity);
                this.field_70170_p.func_217376_c((Entity)endermanEntity);
            }
        }
        super.func_70645_a(cause);
    }

    public static AttributeModifierMap.MutableAttribute generateAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, (double)0.35f).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233819_b_, 64.0);
    }

    static class PlaceBlockGoal
    extends Goal {
        private final EnderTotEntity endertot;

        public PlaceBlockGoal(EnderTotEntity totEntity) {
            this.endertot = totEntity;
        }

        public boolean func_75250_a() {
            if (this.endertot.func_195405_dq() == null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)this.endertot.field_70170_p, (Entity)this.endertot)) {
                return false;
            }
            return this.endertot.func_70681_au().nextInt(2000) == 0;
        }

        public void func_75246_d() {
            Random random = this.endertot.func_70681_au();
            World world = this.endertot.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.endertot.func_226277_ct_() - 1.0 + random.nextDouble() * 2.0));
            int j = MathHelper.func_76128_c((double)(this.endertot.func_226278_cu_() + random.nextDouble() * 2.0));
            int k = MathHelper.func_76128_c((double)(this.endertot.func_226281_cx_() - 1.0 + random.nextDouble() * 2.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = world.func_180495_p(blockpos);
            BlockPos blockpos1 = blockpos.func_177977_b();
            BlockState blockstate1 = world.func_180495_p(blockpos1);
            BlockState blockstate2 = this.endertot.func_195405_dq();
            if (blockstate2 != null && this.canPlaceBlock(world, blockpos, blockstate2 = Block.func_199770_b((BlockState)blockstate2, (IWorld)this.endertot.field_70170_p, (BlockPos)blockpos), blockstate, blockstate1, blockpos1) && !ForgeEventFactory.onBlockPlace((Entity)this.endertot, (BlockSnapshot)BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)blockpos1), (Direction)Direction.UP)) {
                world.func_180501_a(blockpos, blockstate2, 3);
                this.endertot.func_195406_b(null);
            }
        }

        private boolean canPlaceBlock(World p_220836_1_, BlockPos p_220836_2_, BlockState p_220836_3_, BlockState p_220836_4_, BlockState p_220836_5_, BlockPos p_220836_6_) {
            return p_220836_4_.isAir((IBlockReader)p_220836_1_, p_220836_2_) && !p_220836_5_.isAir((IBlockReader)p_220836_1_, p_220836_6_) && !p_220836_5_.func_203425_a(Blocks.field_150357_h) && !p_220836_5_.func_235714_a_((ITag)Tags.Blocks.ENDERMAN_PLACE_ON_BLACKLIST) && p_220836_5_.func_235785_r_((IBlockReader)p_220836_1_, p_220836_6_) && p_220836_3_.func_196955_c((IWorldReader)p_220836_1_, p_220836_2_) && p_220836_1_.func_72839_b((Entity)this.endertot, AxisAlignedBB.func_241549_a_((Vector3d)Vector3d.func_237491_b_((Vector3i)p_220836_2_))).isEmpty();
        }
    }

    static class TakeBlockGoal
    extends Goal {
        private final EnderTotEntity endertot;

        public TakeBlockGoal(EnderTotEntity endertotIn) {
            this.endertot = endertotIn;
        }

        public boolean func_75250_a() {
            if (this.endertot.func_195405_dq() != null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)this.endertot.field_70170_p, (Entity)this.endertot)) {
                return false;
            }
            return this.endertot.func_70681_au().nextInt(20) == 0;
        }

        public void func_75246_d() {
            Random random = this.endertot.func_70681_au();
            World world = this.endertot.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.endertot.func_226277_ct_() - 2.0 + random.nextDouble() * 4.0));
            int j = MathHelper.func_76128_c((double)(this.endertot.func_226278_cu_() + random.nextDouble() * 3.0));
            int k = MathHelper.func_76128_c((double)(this.endertot.func_226281_cx_() - 2.0 + random.nextDouble() * 4.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = world.func_180495_p(blockpos);
            Block block = blockstate.func_177230_c();
            Vector3d vector3d = new Vector3d((double)MathHelper.func_76128_c((double)this.endertot.func_226277_ct_()) + 0.5, (double)j + 0.5, (double)MathHelper.func_76128_c((double)this.endertot.func_226281_cx_()) + 0.5);
            Vector3d vector3d1 = new Vector3d((double)i + 0.5, (double)j + 0.5, (double)k + 0.5);
            BlockRayTraceResult blockraytraceresult = world.func_217299_a(new RayTraceContext(vector3d, vector3d1, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)this.endertot));
            boolean flag = blockraytraceresult.func_216350_a().equals((Object)blockpos);
            ITagCollectionSupplier tagCollection = TagCollectionManager.func_242178_a();
            ITag holdableTag = tagCollection.func_241835_a().func_199910_a(TOT_HOLDABLE);
            if (holdableTag != null && block.func_203417_a(holdableTag) && flag) {
                world.func_217377_a(blockpos, false);
                this.endertot.func_195406_b(blockstate.func_177230_c().func_176223_P());
            }
        }
    }

    static class FindPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        private final EnderTotEntity endertot;
        private PlayerEntity player;
        private int aggroTime;
        private int teleportTime;
        private final EntityPredicate startAggroTargetConditions;
        private final EntityPredicate continueAggroTargetConditions = new EntityPredicate().func_221014_c();

        public FindPlayerGoal(EnderTotEntity enderTotIn, @Nullable Predicate<LivingEntity> p_i241912_2_) {
            super((MobEntity)enderTotIn, PlayerEntity.class, 10, false, false, p_i241912_2_);
            this.endertot = enderTotIn;
            this.startAggroTargetConditions = new EntityPredicate().func_221013_a(this.func_111175_f()).func_221012_a(p_220790_1_ -> enderTotIn.func_70821_d((PlayerEntity)p_220790_1_));
        }

        public boolean func_75250_a() {
            this.player = this.endertot.field_70170_p.func_217370_a(this.startAggroTargetConditions, (LivingEntity)this.endertot);
            return this.player != null;
        }

        public void func_75249_e() {
            this.aggroTime = 5;
            this.teleportTime = 0;
            this.endertot.func_226538_eu_();
        }

        public void func_75251_c() {
            this.player = null;
            super.func_75251_c();
        }

        public boolean func_75253_b() {
            if (this.player != null) {
                if (!this.endertot.func_70821_d(this.player)) {
                    return false;
                }
                this.endertot.func_70625_a((Entity)this.player, 10.0f, 10.0f);
                return true;
            }
            return this.field_75309_a != null && this.continueAggroTargetConditions.func_221015_a((LivingEntity)this.endertot, this.field_75309_a) || super.func_75253_b();
        }

        public void func_75246_d() {
            if (this.endertot.func_70638_az() == null) {
                super.func_234054_a_((LivingEntity)null);
            }
            if (this.player != null) {
                if (--this.aggroTime <= 0) {
                    this.field_75309_a = this.player;
                    this.player = null;
                    super.func_75249_e();
                }
            } else {
                if (this.field_75309_a != null && !this.endertot.func_184218_aH()) {
                    if (this.endertot.func_70821_d((PlayerEntity)this.field_75309_a)) {
                        if (this.field_75309_a.func_70068_e((Entity)this.endertot) < 16.0) {
                            this.endertot.func_70820_n();
                        }
                        this.teleportTime = 0;
                    } else if (this.field_75309_a.func_70068_e((Entity)this.endertot) > 128.0 && this.teleportTime++ >= 30 && this.endertot.func_70816_c((Entity)this.field_75309_a)) {
                        this.teleportTime = 0;
                    }
                }
                super.func_75246_d();
            }
        }
    }

    static class StareGoal
    extends Goal {
        private final EnderTotEntity endertot;
        private LivingEntity targetPlayer;

        public StareGoal(EnderTotEntity endertotIn) {
            this.endertot = endertotIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            this.targetPlayer = this.endertot.func_70638_az();
            if (!(this.targetPlayer instanceof PlayerEntity)) {
                return false;
            }
            double d0 = this.targetPlayer.func_70068_e((Entity)this.endertot);
            return !(d0 > 256.0) && this.endertot.func_70821_d((PlayerEntity)this.targetPlayer);
        }

        public void func_75249_e() {
            this.endertot.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            this.endertot.func_70671_ap().func_220679_a(this.targetPlayer.func_226277_ct_(), this.targetPlayer.func_226280_cw_(), this.targetPlayer.func_226281_cx_());
        }
    }
}

