/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.entities;

import com.mrbysco.forcecraft.entities.IColdMob;
import com.mrbysco.forcecraft.entities.goal.EatGrassToRestoreGoal;
import com.mrbysco.forcecraft.registry.ForceEntities;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ColdPigEntity
extends PigEntity
implements IColdMob {
    private int grassTimer;
    private EatGrassToRestoreGoal eatGrassGoal;
    private ResourceLocation originalTypeLocation;

    public ColdPigEntity(EntityType<? extends PigEntity> type, World worldIn) {
        super(type, worldIn);
        this.originalTypeLocation = new ResourceLocation("minecraft", "pig");
    }

    public ColdPigEntity(World worldIn, ResourceLocation typeLocation) {
        super((EntityType)ForceEntities.COLD_PIG.get(), worldIn);
        if (typeLocation != null) {
            this.originalTypeLocation = typeLocation;
        }
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        return false;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.originalTypeLocation = compound.func_74779_i("OriginalMob").isEmpty() ? new ResourceLocation("minecraft", "pig") : new ResourceLocation(compound.func_74779_i("OriginalMob"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("OriginalMob", this.originalTypeLocation.toString());
    }

    protected void func_184651_r() {
        this.eatGrassGoal = new EatGrassToRestoreGoal((MobEntity)this);
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(5, (Goal)this.eatGrassGoal);
    }

    public static AttributeModifierMap.MutableAttribute generateAttributes() {
        return PigEntity.func_234215_eI_();
    }

    protected void func_70619_bc() {
        this.grassTimer = this.eatGrassGoal.getEatingGrassTimer();
        super.func_70619_bc();
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.grassTimer = Math.max(0, this.grassTimer - 1);
        }
        super.func_70636_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.grassTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        if (this.grassTimer <= 0) {
            return 0.0f;
        }
        if (this.grassTimer >= 4 && this.grassTimer <= 36) {
            return 1.0f;
        }
        return this.grassTimer < 4 ? ((float)this.grassTimer - p_70894_1_) / 4.0f : -((float)(this.grassTimer - 40) - p_70894_1_) / 4.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.grassTimer > 4 && this.grassTimer <= 36) {
            float f = ((float)(this.grassTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.grassTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    @Override
    public ResourceLocation getOriginal() {
        return this.originalTypeLocation;
    }
}

