/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.entities;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.world.World;

public class AngryEndermanEntity
extends EndermanEntity {
    public AngryEndermanEntity(EntityType<? extends EndermanEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 8.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new StareGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new FindPlayerGoal(this, arg_0 -> ((AngryEndermanEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EndermiteEntity.class, 10, true, false, field_213627_bA));
        this.field_70715_bh.func_75776_a(4, (Goal)new ResetAngerGoal((MobEntity)this, false));
    }

    public static AttributeModifierMap.MutableAttribute generateAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233819_b_, 64.0);
    }

    public boolean func_70820_n() {
        if (!this.field_70170_p.func_201670_d() && this.func_70089_S() && !this.func_203005_aq()) {
            double d0 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
            double d1 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(64) - 32);
            double d2 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
            return this.func_70825_j(d0, d1, d2);
        }
        return false;
    }

    static class FindPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        private final AngryEndermanEntity enderman;
        private PlayerEntity player;
        private int aggroTime;
        private int teleportTime;
        private final EntityPredicate startAggroTargetConditions;
        private final EntityPredicate continueAggroTargetConditions = new EntityPredicate().func_221014_c();

        public FindPlayerGoal(AngryEndermanEntity endermantIn, @Nullable Predicate<LivingEntity> p_i241912_2_) {
            super((MobEntity)endermantIn, PlayerEntity.class, 10, false, false, p_i241912_2_);
            this.enderman = endermantIn;
            this.startAggroTargetConditions = new EntityPredicate().func_221013_a(this.func_111175_f()).func_221012_a(p_220790_1_ -> endermantIn.func_70821_d((PlayerEntity)p_220790_1_));
        }

        public boolean func_75250_a() {
            this.player = this.enderman.field_70170_p.func_217370_a(this.startAggroTargetConditions, (LivingEntity)this.enderman);
            return this.player != null;
        }

        public void func_75249_e() {
            this.aggroTime = 5;
            this.teleportTime = 0;
            this.enderman.func_226538_eu_();
        }

        public void func_75251_c() {
            this.player = null;
            super.func_75251_c();
        }

        public boolean func_75253_b() {
            if (this.player != null) {
                if (!this.enderman.func_70821_d(this.player)) {
                    return false;
                }
                this.enderman.func_70625_a((Entity)this.player, 10.0f, 10.0f);
                return true;
            }
            return this.field_75309_a != null && this.continueAggroTargetConditions.func_221015_a((LivingEntity)this.enderman, this.field_75309_a) ? true : super.func_75253_b();
        }

        public void func_75246_d() {
            if (this.enderman.func_70638_az() == null) {
                super.func_234054_a_((LivingEntity)null);
            }
            if (this.player != null) {
                if (--this.aggroTime <= 0) {
                    this.field_75309_a = this.player;
                    this.player = null;
                    super.func_75249_e();
                }
            } else {
                if (this.field_75309_a != null && !this.enderman.func_184218_aH()) {
                    if (this.enderman.func_70821_d((PlayerEntity)this.field_75309_a)) {
                        if (this.field_75309_a.func_70068_e((Entity)this.enderman) < 16.0) {
                            this.enderman.func_70820_n();
                        }
                        this.teleportTime = 0;
                    } else if (this.field_75309_a.func_70068_e((Entity)this.enderman) > 128.0 && this.teleportTime++ >= 30 && this.enderman.func_70816_c((Entity)this.field_75309_a)) {
                        this.teleportTime = 0;
                    }
                }
                super.func_75246_d();
            }
        }
    }

    static class StareGoal
    extends Goal {
        private final EndermanEntity enderman;
        private LivingEntity targetPlayer;

        public StareGoal(EndermanEntity endermanIn) {
            this.enderman = endermanIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            this.targetPlayer = this.enderman.func_70638_az();
            if (!(this.targetPlayer instanceof PlayerEntity)) {
                return false;
            }
            double d0 = this.targetPlayer.func_70068_e((Entity)this.enderman);
            return d0 > 256.0 ? false : this.enderman.func_70821_d((PlayerEntity)this.targetPlayer);
        }

        public void func_75249_e() {
            this.enderman.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            this.enderman.func_70671_ap().func_220679_a(this.targetPlayer.func_226277_ct_(), this.targetPlayer.func_226280_cw_(), this.targetPlayer.func_226281_cx_());
        }
    }
}

