/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.container.furnace;

import com.mrbysco.forcecraft.container.furnace.slot.ForceFurnaceFuelSlot;
import com.mrbysco.forcecraft.container.furnace.slot.ForceFurnaceResultSlot;
import com.mrbysco.forcecraft.container.furnace.slot.UpgradeSlot;
import com.mrbysco.forcecraft.items.UpgradeCoreItem;
import com.mrbysco.forcecraft.recipe.ForceRecipes;
import com.mrbysco.forcecraft.registry.ForceContainers;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.tiles.AbstractForceFurnaceTile;
import java.util.Objects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public abstract class AbstractForceFurnaceContainer
extends Container {
    private AbstractForceFurnaceTile tile;
    private PlayerEntity player;
    private IItemHandler furnaceInventory;
    private IItemHandler upgradeInventory;
    private IIntArray furnaceData;
    private World world;

    public AbstractForceFurnaceContainer(int windowId, PlayerInventory playerInventory, PacketBuffer data) {
        this(windowId, playerInventory, AbstractForceFurnaceContainer.getTileEntity(playerInventory, data));
    }

    protected static AbstractForceFurnaceTile getTileEntity(PlayerInventory playerInventory, PacketBuffer data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        TileEntity tileAtPos = playerInventory.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        if (tileAtPos instanceof AbstractForceFurnaceTile) {
            return (AbstractForceFurnaceTile)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public AbstractForceFurnaceContainer(int id, PlayerInventory playerInventoryIn, AbstractForceFurnaceTile te) {
        super((ContainerType)ForceContainers.FORCE_FURNACE.get(), id);
        this.tile = te;
        this.player = playerInventoryIn.field_70458_d;
        this.world = this.player.field_70170_p;
        this.furnaceInventory = this.tile.handler;
        this.upgradeInventory = this.tile.upgradeHandler;
        this.furnaceData = this.tile.getFurnaceData();
        this.assertFurnaceSize(this.furnaceInventory, 3);
        this.assertFurnaceSize(this.upgradeInventory, 1);
        AbstractForceFurnaceContainer.func_216959_a((IIntArray)this.furnaceData, (int)4);
        this.func_75146_a((Slot)new SlotItemHandler(this.furnaceInventory, 0, 56, 17));
        this.func_75146_a((Slot)new ForceFurnaceFuelSlot(this, this.furnaceInventory, 1, 56, 53));
        this.func_75146_a((Slot)new ForceFurnaceResultSlot(this.player, this.furnaceInventory, 2, 116, 35));
        this.func_75146_a((Slot)new UpgradeSlot(this.upgradeInventory, 0, 12, 12));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventoryIn, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventoryIn, k, 8 + k * 18, 142));
        }
        this.func_216961_a(this.furnaceData);
    }

    public int getBurn() {
        return this.furnaceData.func_221476_a(0);
    }

    protected void assertFurnaceSize(IItemHandler inventoryIn, int minSize) {
        int i = inventoryIn.getSlots();
        if (i < minSize) {
            throw new IllegalArgumentException("Container size " + i + " is smaller than expected " + minSize);
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.tile.func_70300_a(playerIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 2) {
                if (!this.func_75135_a(itemstack1, 4, 40, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index != 1 && index != 0) {
                if (this.hasRecipe(itemstack1)) {
                    if (!this.func_75135_a(itemstack1, 0, 1, false)) {
                        return ItemStack.field_190927_a;
                    }
                } else if (this.isFuel(itemstack1)) {
                    if (!this.func_75135_a(itemstack1, 1, 2, false)) {
                        return ItemStack.field_190927_a;
                    }
                } else {
                    if (AbstractForceFurnaceContainer.isUpgrade(itemstack1) && index == 3) {
                        itemstack1.func_190918_g(1);
                        playerIn.field_70170_p.func_184133_a((PlayerEntity)null, playerIn.func_233580_cy_(), SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        return ItemStack.field_190927_a;
                    }
                    if (index >= 4 && index < 31 ? !this.func_75135_a(itemstack1, 31, 40, false) : index >= 31 && index < 40 && !this.func_75135_a(itemstack1, 4, 31, false)) {
                        return ItemStack.field_190927_a;
                    }
                }
            } else if (!this.func_75135_a(itemstack1, 4, 40, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected boolean hasRecipe(ItemStack stack) {
        return this.world.func_199532_z().func_215371_a(this.getRecipeType(), (IInventory)new Inventory(new ItemStack[]{stack}), this.world).isPresent();
    }

    protected IRecipeType<? extends AbstractCookingRecipe> getRecipeType() {
        IRecipeType recipeType = IRecipeType.field_222150_b;
        ItemStack upgrade = this.upgradeInventory.getStackInSlot(0);
        if (!upgrade.func_190926_b()) {
            if (upgrade.func_77973_b() == ForceRegistry.FREEZING_CORE.get()) {
                return ForceRecipes.FREEZING;
            }
            if (upgrade.func_77973_b() == ForceRegistry.GRINDING_CORE.get()) {
                return ForceRecipes.GRINDING;
            }
        }
        return recipeType;
    }

    public boolean isFuel(ItemStack stack) {
        return AbstractForceFurnaceTile.isFuel(stack);
    }

    public static boolean isUpgrade(ItemStack stack) {
        return stack.func_77973_b() instanceof UpgradeCoreItem;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        Slot slot;
        if (clickTypeIn == ClickType.PICKUP_ALL && player.field_71071_by.func_70445_o().func_77973_b() instanceof UpgradeCoreItem) {
            return ItemStack.field_190927_a;
        }
        if (slotId == 3 && (slot = this.func_75139_a(slotId)).func_75216_d() && clickTypeIn != ClickType.QUICK_MOVE) {
            player.field_70170_p.func_184133_a((PlayerEntity)null, player.func_233580_cy_(), SoundEvents.field_187909_gi, SoundCategory.PLAYERS, 0.5f, 1.0f);
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookProgressionScaled() {
        int i = this.furnaceData.func_221476_a(2);
        int j = this.furnaceData.func_221476_a(3);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBurnLeftScaled() {
        int i = this.furnaceData.func_221476_a(1);
        if (i == 0) {
            i = 200;
        }
        return this.furnaceData.func_221476_a(0) * 13 / i;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isBurning() {
        return this.furnaceData.func_221476_a(0) > 0;
    }
}

