/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.container.engine;

import com.mrbysco.forcecraft.container.engine.slot.FuelSlot;
import com.mrbysco.forcecraft.container.engine.slot.OutputSlot;
import com.mrbysco.forcecraft.container.engine.slot.ThrottleSlot;
import com.mrbysco.forcecraft.registry.ForceContainers;
import com.mrbysco.forcecraft.tiles.ForceEngineTile;
import java.util.Objects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IntReferenceHolder;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class ForceEngineContainer
extends Container {
    private ForceEngineTile tile;
    private PlayerEntity player;

    public ForceEngineContainer(int windowId, PlayerInventory playerInventory, PacketBuffer data) {
        this(windowId, playerInventory, ForceEngineContainer.getTileEntity(playerInventory, data));
    }

    private static ForceEngineTile getTileEntity(PlayerInventory playerInventory, PacketBuffer data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        TileEntity tileAtPos = playerInventory.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        if (tileAtPos instanceof ForceEngineTile) {
            return (ForceEngineTile)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public ForceEngineContainer(int id, PlayerInventory playerInventoryIn, ForceEngineTile te) {
        super((ContainerType)ForceContainers.FORCE_ENGINE.get(), id);
        this.tile = te;
        this.player = playerInventoryIn.field_70458_d;
        this.func_75146_a((Slot)new FuelSlot((IItemHandler)te.inputHandler, 0, 42, 23));
        this.func_75146_a((Slot)new ThrottleSlot((IItemHandler)te.inputHandler, 1, 118, 23));
        this.func_75146_a((Slot)new OutputSlot((IItemHandler)te.outputHandler, 0, 42, 42));
        this.func_75146_a((Slot)new OutputSlot((IItemHandler)te.outputHandler, 1, 118, 42));
        int xPos = 8;
        int yPos = 79;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInventoryIn, x + y * 9 + 9, xPos + x * 18, yPos + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInventoryIn, x, xPos + x * 18, yPos + 58));
        }
        this.trackFluids();
    }

    private void trackFluids() {
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return ForceEngineContainer.this.tile.getFuelAmount() & 0xFFFF;
            }

            public void func_221494_a(int value) {
                int fluidStored = ForceEngineContainer.this.tile.getFuelAmount() & 0xFFFF0000;
                ForceEngineContainer.this.tile.setFuelAmount(fluidStored + (value & 0xFFFF));
            }
        });
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return ForceEngineContainer.this.tile.getFuelAmount() >> 16 & 0xFFFF;
            }

            public void func_221494_a(int value) {
                int fluidStored = ForceEngineContainer.this.tile.getFuelAmount() & 0xFFFF;
                ForceEngineContainer.this.tile.setFuelAmount(fluidStored | value << 16);
            }
        });
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return ForceEngineContainer.this.tile.getThrottleAmount() & 0xFFFF;
            }

            public void func_221494_a(int value) {
                int fluidStored = ForceEngineContainer.this.tile.getThrottleAmount() & 0xFFFF0000;
                ForceEngineContainer.this.tile.setThrottleAmount(fluidStored + (value & 0xFFFF));
            }
        });
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return ForceEngineContainer.this.tile.getThrottleAmount() >> 16 & 0xFFFF;
            }

            public void func_221494_a(int value) {
                int fluidStored = ForceEngineContainer.this.tile.getThrottleAmount() & 0xFFFF;
                ForceEngineContainer.this.tile.setThrottleAmount(fluidStored | value << 16);
            }
        });
    }

    public ForceEngineTile getTile() {
        return this.tile;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.tile.isUsableByPlayer(playerIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            int tileSize = 2;
            if (itemstack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent() && itemstack.func_77976_d() > 1) {
                return ItemStack.field_190927_a;
            }
            if (index < 2 ? !this.func_75135_a(itemstack1, 2, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, 2, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(this.player, itemstack1);
        }
        return itemstack;
    }

    public void func_75142_b() {
        super.func_75142_b();
    }
}

