/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.container;

import com.mrbysco.forcecraft.items.ItemCardItem;
import com.mrbysco.forcecraft.registry.ForceContainers;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class ItemCardContainer
extends Container {
    private final CraftingInventory craftMatrix = new CraftingInventory((Container)this, 3, 3);
    private final CraftResultInventory craftResult = new CraftResultInventory();
    private final IWorldPosCallable worldPosCallable;
    private final PlayerEntity player;
    private ItemStack heldStack;

    public ItemCardContainer(int id, PlayerInventory playerInventory) {
        this(id, playerInventory, IWorldPosCallable.field_221489_a);
    }

    public ItemCardContainer(int id, PlayerInventory playerInventory, IWorldPosCallable worldPosCallable) {
        super((ContainerType)ForceContainers.ITEM_CARD.get(), id);
        CompoundNBT tag;
        this.worldPosCallable = worldPosCallable;
        this.player = playerInventory.field_70458_d;
        this.func_75146_a((Slot)new CraftingResultSlot(playerInventory.field_70458_d, this.craftMatrix, (IInventory)this.craftResult, 0, 124, 35){

            public boolean func_82869_a(PlayerEntity playerIn) {
                return false;
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, j + i * 3, 30 + j * 18, 17 + i * 18){

                    public int func_75219_a() {
                        return 1;
                    }

                    @Nonnull
                    public ItemStack func_190901_a(PlayerEntity player, @Nonnull ItemStack stack) {
                        return ItemStack.field_190927_a;
                    }

                    @Nonnull
                    public ItemStack func_75209_a(int par1) {
                        return ItemStack.field_190927_a;
                    }

                    public boolean func_75214_a(ItemStack par1ItemStack) {
                        return false;
                    }

                    public boolean func_82869_a(PlayerEntity par1PlayerEntity) {
                        return false;
                    }
                });
            }
        }
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.func_75146_a(new Slot((IInventory)playerInventory, i1 + k * 9 + 9, 8 + i1 * 18, 84 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.func_75146_a(new Slot((IInventory)playerInventory, l, 8 + l * 18, 142));
        }
        this.heldStack = ItemCardContainer.getCardStack(playerInventory);
        if (this.heldStack.func_77973_b() == ForceRegistry.ITEM_CARD.get() && (tag = this.heldStack.func_196082_o()).func_74764_b("RecipeContents")) {
            CompoundNBT recipeContents = tag.func_74775_l("RecipeContents");
            if (!this.player.field_70170_p.field_72995_K) {
                for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
                    this.craftMatrix.func_70299_a(i, ItemStack.func_199557_a((CompoundNBT)recipeContents.func_74775_l("slot_" + i)));
                }
                this.craftResult.func_70299_a(0, ItemStack.func_199557_a((CompoundNBT)recipeContents.func_74775_l("result")));
            }
        }
    }

    public static ItemStack getCardStack(PlayerInventory playerInventory) {
        PlayerEntity player = playerInventory.field_70458_d;
        if (player.func_184614_ca().func_77973_b() instanceof ItemCardItem) {
            return player.func_184614_ca();
        }
        if (player.func_184592_cb().func_77973_b() instanceof ItemCardItem) {
            return player.func_184592_cb();
        }
        return ItemStack.field_190927_a;
    }

    protected void updateCraftingResult(World world, PlayerEntity player, CraftingInventory inventory, CraftResultInventory inventoryResult) {
        if (!world.field_72995_K) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)player;
            Optional iRecipe = serverplayerentity.field_71133_b.func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)inventory, world);
            if (iRecipe.isPresent() && (((ICraftingRecipe)iRecipe.get()).func_192399_d() || !world.func_82736_K().func_223586_b(GameRules.field_223618_u) || serverplayerentity.func_192037_E().func_193830_f((IRecipe)iRecipe.get()) || player.func_184812_l_())) {
                ItemStack stack = ((ICraftingRecipe)iRecipe.get()).func_77572_b((IInventory)this.craftMatrix);
                inventoryResult.func_70299_a(0, stack);
                serverplayerentity.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, 0, stack));
            } else {
                inventoryResult.func_70299_a(0, ItemStack.field_190927_a);
                serverplayerentity.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, 0, ItemStack.field_190927_a));
            }
        }
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.worldPosCallable.func_221486_a((world, pos) -> this.updateCraftingResult((World)world, this.player, this.craftMatrix, this.craftResult));
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return !this.heldStack.func_190926_b();
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        int total_crafting_slots = 10;
        if (index <= 10) {
            return ItemStack.field_190927_a;
        }
        int total_slots = 46;
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 0) {
                if (!this.func_75135_a(itemstack1, 10, 46, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index < 32 ? !this.func_75135_a(itemstack1, 32, 46, false) : index < 46 && !this.func_75135_a(itemstack1, 10, 32, false) || !this.func_75135_a(itemstack1, 10, 46, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
        }
        return itemstack;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        if (slotId >= 1 && slotId < 10) {
            if (clickTypeIn == ClickType.PICKUP || clickTypeIn == ClickType.PICKUP_ALL || clickTypeIn == ClickType.SWAP) {
                Slot slot = (Slot)this.field_75151_b.get(slotId);
                ItemStack dropping = player.field_71071_by.func_70445_o();
                return this.handleSlotClick(slot, dropping);
            }
            return ItemStack.field_190927_a;
        }
        if (clickTypeIn == ClickType.QUICK_MOVE) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack handleSlotClick(Slot slotId, ItemStack stack) {
        if (stack.func_190916_E() > 0) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(1);
            slotId.func_75215_d(copy);
        } else if (slotId.func_75211_c().func_190916_E() > 0) {
            slotId.func_75215_d(ItemStack.field_190927_a);
        }
        return slotId.func_75211_c().func_77946_l();
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.craftResult && super.func_94530_a(stack, slotIn);
    }

    public CraftingInventory getCraftMatrix() {
        return this.craftMatrix;
    }

    public CraftResultInventory getCraftResult() {
        return this.craftResult;
    }

    public PlayerEntity getPlayer() {
        return this.player;
    }

    public void setMatrixContents(PlayerEntity player, List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            this.handleSlotClick(this.func_75139_a(i), stacks.get(i));
        }
    }

    public List<ItemStack> getMatrixContents() {
        return null;
    }
}

