/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.container;

import com.mrbysco.forcecraft.capablilities.pack.PackItemStackHandler;
import com.mrbysco.forcecraft.items.ForceBeltItem;
import com.mrbysco.forcecraft.items.ForcePackItem;
import com.mrbysco.forcecraft.items.ItemCardItem;
import com.mrbysco.forcecraft.registry.ForceContainers;
import com.mrbysco.forcecraft.util.FindingUtil;
import com.mrbysco.forcecraft.util.ItemHandlerUtils;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.SlotItemHandler;

public class ForcePackContainer
extends Container {
    private ItemStack heldStack;
    private int upgrades;

    public boolean func_75145_c(PlayerEntity playerIn) {
        return !playerIn.func_175149_v();
    }

    public ForcePackContainer(int id, PlayerInventory playerInventory) {
        super((ContainerType)ForceContainers.FORCE_PACK.get(), id);
        this.heldStack = FindingUtil.findInstanceStack(playerInventory.field_70458_d, stack -> stack.func_77973_b() instanceof ForcePackItem);
        if (this.heldStack == null || this.heldStack.func_190926_b()) {
            playerInventory.field_70458_d.func_71053_j();
            return;
        }
        this.upgrades = 0;
        IItemHandler itemHandler = (IItemHandler)this.heldStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (itemHandler instanceof PackItemStackHandler) {
            this.upgrades = ((PackItemStackHandler)itemHandler).getUpgrades();
            int numRows = this.upgrades + 1;
            int xPosC = 17;
            int yPosC = 20;
            for (int j = 0; j < numRows; ++j) {
                for (int k = 0; k < 8; ++k) {
                    this.func_75146_a((Slot)new SlotItemHandler(itemHandler, k + j * 8, xPosC + k * 18, yPosC + j * 18){

                        public boolean func_75214_a(@Nonnull ItemStack stack) {
                            return !(stack.func_77973_b() instanceof ForcePackItem) && !(stack.func_77973_b() instanceof ForceBeltItem);
                        }
                    });
                }
            }
            int xPos = 8;
            int yPos = 36 + numRows * 18;
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.func_75146_a(new Slot((IInventory)playerInventory, x + y * 9 + 9, xPos + x * 18, yPos + y * 18));
                }
            }
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInventory, x, xPos + x * 18, yPos + 58));
            }
        } else {
            playerInventory.field_70458_d.func_71053_j();
        }
    }

    public void func_75134_a(PlayerEntity playerIn) {
        IItemHandler itemHandler = (IItemHandler)this.heldStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (itemHandler instanceof PackItemStackHandler) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                CompoundNBT tag = stack.func_77978_p();
                if (!(stack.func_77973_b() instanceof ItemCardItem) || tag == null || !tag.func_74764_b("RecipeContents")) continue;
                CompoundNBT recipeContents = tag.func_74775_l("RecipeContents");
                NonNullList ingredientList = NonNullList.func_191196_a();
                ArrayList<ItemStack> mergeList = new ArrayList<ItemStack>();
                for (int j = 0; j < 9; ++j) {
                    ItemStack recipeStack = ItemStack.func_199557_a((CompoundNBT)recipeContents.func_74775_l("slot_" + j));
                    if (recipeStack.func_190926_b()) continue;
                    if (ingredientList.isEmpty()) {
                        ingredientList.add((Object)recipeStack);
                        continue;
                    }
                    mergeList.add(recipeStack);
                }
                for (ItemStack recipeStack : mergeList) {
                    if (ingredientList.isEmpty()) continue;
                    ArrayList<ItemStack> buffer = new ArrayList<ItemStack>();
                    for (ItemStack ingredient : ingredientList) {
                        if (ingredient != null && !ingredient.func_190926_b() && ForcePackContainer.func_195929_a((ItemStack)ingredient, (ItemStack)recipeStack)) {
                            int maxCount;
                            int addedCount = ingredient.func_190916_E() + recipeStack.func_190916_E();
                            if (addedCount <= (maxCount = ingredient.func_77976_d())) {
                                recipeStack.func_190920_e(0);
                                ingredient.func_190920_e(addedCount);
                            } else if (recipeStack.func_190916_E() < maxCount) {
                                recipeStack.func_190918_g(maxCount - ingredient.func_190916_E());
                                ingredient.func_190920_e(maxCount);
                            }
                        }
                        if (recipeStack.func_190926_b()) continue;
                        buffer.add(recipeStack);
                    }
                    if (buffer.isEmpty()) continue;
                    ingredientList.addAll(buffer);
                }
                mergeList.clear();
                ArrayList<ItemStack> restList = new ArrayList<ItemStack>();
                for (int k = 0; k < itemHandler.getSlots(); ++k) {
                    ItemStack restStack;
                    if (k == i || (restStack = itemHandler.getStackInSlot(k)).func_190926_b()) continue;
                    restList.add(restStack);
                }
                boolean canCraft = true;
                int craftCount = 64;
                for (ItemStack ingredient : ingredientList) {
                    int countPossible = 0;
                    for (ItemStack rest : restList) {
                        if (ingredient.func_77973_b() != rest.func_77973_b() || !ItemStack.func_77970_a((ItemStack)ingredient, (ItemStack)rest)) continue;
                        countPossible = (int)((double)countPossible + (double)rest.func_190916_E() / (double)ingredient.func_190916_E());
                    }
                    if (countPossible == 0) {
                        canCraft = false;
                        craftCount = 0;
                        break;
                    }
                    if (countPossible >= craftCount) continue;
                    craftCount = countPossible;
                }
                ItemStack craftStack = ItemStack.func_199557_a((CompoundNBT)recipeContents.func_74775_l("result"));
                if (!canCraft || craftCount <= 0) continue;
                for (int l = 0; l < craftCount; ++l) {
                    for (ItemStack ingredient : ingredientList) {
                        for (ItemStack rest : restList) {
                            if (ingredient.func_77973_b() != rest.func_77973_b() || !ItemStack.func_77970_a((ItemStack)ingredient, (ItemStack)rest) || rest.func_190916_E() < ingredient.func_190916_E()) continue;
                            rest.func_190918_g(ingredient.func_190916_E());
                        }
                    }
                    ItemStack stackCopy = craftStack.func_77946_l();
                    ItemStack craftedStack = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stackCopy, (boolean)false);
                    if (craftedStack.func_190926_b()) continue;
                    playerIn.func_71019_a(craftedStack, true);
                }
            }
            CompoundNBT tag = this.heldStack.func_196082_o();
            tag.func_74768_a("SlotsUsed", ItemHandlerUtils.getUsedSlots(itemHandler));
            this.heldStack.func_77982_d(tag);
        }
        super.func_75134_a(playerIn);
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        if (slotId >= 0 && this.func_75139_a(slotId).func_75211_c().func_77973_b() instanceof ForcePackItem) {
            return ItemStack.field_190927_a;
        }
        if (clickTypeIn == ClickType.SWAP) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public int getUpgrades() {
        return this.upgrades;
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (itemstack.func_77973_b() instanceof ForcePackItem) {
                return ItemStack.field_190927_a;
            }
            int containerSlots = this.field_75151_b.size() - player.field_71071_by.field_70462_a.size();
            if (index < containerSlots ? !this.func_75135_a(itemstack1, containerSlots, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, containerSlots, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
        }
        return itemstack;
    }
}

