/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.compat.jei.multipleoutput;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrbysco.forcecraft.compat.jei.JeiCompat;
import com.mrbysco.forcecraft.recipe.MultipleOutputFurnaceRecipe;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.util.Translator;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractMultiOutputCategory<T extends MultipleOutputFurnaceRecipe>
implements IRecipeCategory<T> {
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;
    private final boolean showChance;

    public AbstractMultiOutputCategory(IGuiHelper guiHelper, Block icon, String translationKey, int yOffset, boolean showChance) {
        this.background = guiHelper.createDrawable(JeiCompat.RECIPE_MULTIPLES_JEI, 0, yOffset, 140, 37);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)icon));
        this.localizedName = Translator.translateToLocal((String)translationKey);
        this.showChance = showChance;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(T recipe, IIngredients ingredients) {
        ingredients.setInputIngredients((List)recipe.func_192400_c());
        ingredients.setOutputs(VanillaTypes.ITEM, ((MultipleOutputFurnaceRecipe)((Object)recipe)).getRecipeOutputs());
    }

    public void draw(T recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
    }

    public String getTitle() {
        return this.localizedName;
    }

    public void setRecipe(IRecipeLayout recipeLayout, final T recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 9, 9);
        guiItemStacks.init(1, false, 82, 9);
        guiItemStacks.init(2, false, 112, 9);
        guiItemStacks.set(ingredients);
        if (this.showChance) {
            recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)new ITooltipCallback<ItemStack>(){

                @OnlyIn(value=Dist.CLIENT)
                public void onTooltip(int slot, boolean input, ItemStack stack, List<ITextComponent> list) {
                    if (!input && slot == 2) {
                        list.add((ITextComponent)new StringTextComponent(recipe.getSecondaryChance() * 100.0f + " ").func_230529_a_((ITextComponent)new TranslationTextComponent("forcecraft.gui.jei.category.grinding.tooltip")).func_240699_a_(TextFormatting.YELLOW));
                    }
                }
            });
        }
    }
}

