/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.compat.jei.infuser;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrbysco.forcecraft.blocks.infuser.InfuserModifierType;
import com.mrbysco.forcecraft.compat.jei.JeiCompat;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookData;
import com.mrbysco.forcecraft.recipe.InfuseRecipe;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class InfuserCategory<T extends InfuseRecipe>
implements IRecipeCategory<InfuseRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;

    public InfuserCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(JeiCompat.RECIPE_INFUSER_JEI, 0, 0, 137, 109);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ForceRegistry.INFUSER.get()));
        this.localizedName = Translator.translateToLocal((String)"forcecraft.gui.jei.category.infuser");
    }

    public ResourceLocation getUid() {
        return JeiCompat.INFUSER;
    }

    public Class<? extends InfuseRecipe> getRecipeClass() {
        return InfuseRecipe.class;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(InfuseRecipe recipe, IIngredients ingredients) {
        ItemStack[] matchingStacks = recipe.getCenter().func_193365_a();
        ingredients.setInputIngredients(recipe.func_192400_c());
        if (recipe.func_77571_b().func_190926_b()) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            ItemStack[] modifierStack = recipe.getInput().func_193365_a();
            if (modifierStack.length > 0) {
                InfuserModifierType type = recipe.getModifier();
                UpgradeBookData fakeUpgradeBook = new UpgradeBookData(new ItemStack((IItemProvider)ForceRegistry.UPGRADE_TOME.get()));
                fakeUpgradeBook.setTier(recipe.getTier());
                for (ItemStack center : matchingStacks) {
                    ItemStack centerStack = center.func_77946_l();
                    if (centerStack.func_77973_b() == ForceRegistry.FORCE_PACK.get()) {
                        type.apply(centerStack, modifierStack[0], fakeUpgradeBook);
                        type.apply(centerStack, modifierStack[0], fakeUpgradeBook);
                        type.apply(centerStack, modifierStack[0], fakeUpgradeBook);
                        type.apply(centerStack, modifierStack[0], fakeUpgradeBook);
                    } else {
                        type.apply(centerStack, modifierStack[0], fakeUpgradeBook);
                    }
                    stacks.add(centerStack);
                }
                ingredients.setOutputs(VanillaTypes.ITEM, stacks);
            } else {
                ingredients.setOutput(VanillaTypes.ITEM, (Object)matchingStacks[0]);
            }
        } else {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
        }
    }

    public void draw(InfuseRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer font = minecraft.field_71466_p;
        font.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("forcecraft.gui.jei.category.infuser.tier", new Object[]{recipe.getTier().asInt()}), 4.0f, 4.0f, -1);
    }

    public String getTitle() {
        return this.localizedName;
    }

    public void setRecipe(IRecipeLayout recipeLayout, InfuseRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 45, 46);
        guiItemStacks.init(1, true, 45, 9);
        guiItemStacks.init(2, false, 119, 46);
        ArrayList outputFull = new ArrayList();
        for (List stackList : ingredients.getOutputs(VanillaTypes.ITEM)) {
            outputFull.add(stackList.get(0));
        }
        guiItemStacks.set(ingredients);
        guiItemStacks.set(2, outputFull);
    }
}

