/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class RenderHelper {
    public static void drawFluidTankInGUI(FluidStack fluid, double x, double y, double percent, int height) {
        TextureAtlasSprite sprite;
        if (fluid == null || fluid.isEmpty()) {
            return;
        }
        ResourceLocation flowing = fluid.getFluid().getAttributes().getStillTexture(fluid);
        Texture texture = Minecraft.func_71410_x().func_110434_K().func_229267_b_(PlayerContainer.field_226615_c_);
        if (texture instanceof AtlasTexture && (sprite = ((AtlasTexture)texture).func_195424_a(flowing)) != null) {
            float minU = sprite.func_94209_e();
            float maxU = sprite.func_94212_f();
            float minV = sprite.func_94206_g();
            float maxV = sprite.func_94210_h();
            float deltaV = maxV - minV;
            double tankLevel = percent * (double)height;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(PlayerContainer.field_226615_c_);
            Color color = new Color(fluid.getFluid().getAttributes().getColor());
            RenderSystem.color4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
            RenderSystem.enableBlend();
            int count = 1 + (int)Math.ceil(tankLevel) / 16;
            for (int i = 0; i < count; ++i) {
                double subHeight = Math.min(16.0, tankLevel - 16.0 * (double)i);
                double offsetY = (double)height - 16.0 * (double)i - subHeight;
                RenderHelper.drawQuad(x, y + offsetY, 16.0, subHeight, minU, (float)((double)maxV - (double)deltaV * (subHeight / 16.0)), maxU, maxV);
            }
            RenderSystem.disableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static void drawQuad(double x, double y, double width, double height, float minU, float minV, float maxU, float maxV) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_(x, y + height, 0.0).func_225583_a_(minU, maxV).func_181675_d();
        buffer.func_225582_a_(x + width, y + height, 0.0).func_225583_a_(maxU, maxV).func_181675_d();
        buffer.func_225582_a_(x + width, y, 0.0).func_225583_a_(maxU, minV).func_181675_d();
        buffer.func_225582_a_(x, y, 0.0).func_225583_a_(minU, minV).func_181675_d();
        tessellator.func_78381_a();
    }

    public static float getTankPercentage(int fluidAmount, int fluidMax) {
        return (float)fluidAmount / (float)fluidMax;
    }

    public static int getFluidGuiPercentage(int percentage, int maxHeight) {
        return (int)Math.ceil((float)percentage * (float)maxHeight);
    }
}

