/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.client.gui.engine;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrbysco.forcecraft.client.util.RenderHelper;
import com.mrbysco.forcecraft.container.engine.ForceEngineContainer;
import com.mrbysco.forcecraft.tiles.ForceEngineTile;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class ForceEngineScreen
extends ContainerScreen<ForceEngineContainer> {
    private final ResourceLocation TEXTURE = new ResourceLocation("forcecraft", "textures/gui/container/force_engine.png");

    public ForceEngineScreen(ForceEngineContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        this.field_230706_i_.func_110434_K().func_110577_a(this.TEXTURE);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawFuelTank(matrixStack);
        this.drawThrottleTank(matrixStack);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        ArrayList<Object> text;
        int actualMouseX = mouseX - (this.field_230708_k_ - this.field_146999_f) / 2;
        int actualMouseY = mouseY - (this.field_230709_l_ - this.field_147000_g) / 2;
        ForceEngineTile tile = ((ForceEngineContainer)this.func_212873_a_()).getTile();
        if (this.func_195359_a(66, 11, 16, 58, mouseX, mouseY)) {
            text = new ArrayList<Object>();
            if (tile.getFuelFluid() == null) {
                text.add(new TranslationTextComponent("gui.forcecraft.force_engine.empty"));
            } else if (tile.getFuelFluidStack() != null) {
                text.add(tile.getFuelFluidStack().getDisplayName());
                text.add(new StringTextComponent(tile.getFuelAmount() + " mb").func_240699_a_(TextFormatting.GOLD));
            }
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, text, (int)actualMouseX, (int)actualMouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
        }
        if (this.func_195359_a(94, 11, 16, 58, mouseX, mouseY)) {
            text = new ArrayList();
            if (tile.getThrottleFluid() == null) {
                text.add(new TranslationTextComponent("gui.forcecraft.force_engine.empty"));
            } else if (tile.getThrottleFluidStack() != null) {
                text.add(tile.getThrottleFluidStack().getDisplayName());
                text.add(new StringTextComponent(tile.getThrottleAmount() + " mb").func_240699_a_(TextFormatting.GOLD));
            }
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, text, (int)actualMouseX, (int)actualMouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
        }
    }

    private void drawFuelTank(MatrixStack matrixStack) {
        if (((ForceEngineContainer)this.field_147002_h).getTile() == null || ((ForceEngineContainer)this.field_147002_h).getTile().getFuelFluid() == null) {
            return;
        }
        FluidStack fluidStack = ((ForceEngineContainer)this.field_147002_h).getTile().getFuelFluidStack();
        float tankPercentage = RenderHelper.getTankPercentage(((ForceEngineContainer)this.func_212873_a_()).getTile().getFuelAmount(), 10000);
        RenderHelper.drawFluidTankInGUI(fluidStack, this.field_147003_i + 66, this.field_147009_r + 11, tankPercentage, 58);
        this.field_230706_i_.field_71446_o.func_110577_a(this.TEXTURE);
        this.func_238474_b_(matrixStack, this.field_147003_i + 66, this.field_147009_r + 11, 176, 0, 16, 64);
    }

    private void drawThrottleTank(MatrixStack matrixStack) {
        if (((ForceEngineContainer)this.field_147002_h).getTile() == null || ((ForceEngineContainer)this.field_147002_h).getTile().getThrottleFluid() == null) {
            return;
        }
        FluidStack fluidStack = ((ForceEngineContainer)this.field_147002_h).getTile().getThrottleFluidStack();
        float tankPercentage = RenderHelper.getTankPercentage(((ForceEngineContainer)this.func_212873_a_()).getTile().getThrottleAmount(), 10000);
        RenderHelper.drawFluidTankInGUI(fluidStack, this.field_147003_i + 94, this.field_147009_r + 11, tankPercentage, 58);
        this.field_230706_i_.field_71446_o.func_110577_a(this.TEXTURE);
        this.func_238474_b_(matrixStack, this.field_147003_i + 94, this.field_147009_r + 11, 176, 0, 16, 64);
    }
}

