/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.capablilities.toolmodifier;

import com.mrbysco.forcecraft.capablilities.CapabilityHandler;
import com.mrbysco.forcecraft.capablilities.toolmodifier.IToolModifier;
import com.mrbysco.forcecraft.items.ForceArmorItem;
import com.mrbysco.forcecraft.items.tools.ForceBowItem;
import com.mrbysco.forcecraft.items.tools.ForcePickaxeItem;
import com.mrbysco.forcecraft.items.tools.ForceRodItem;
import com.mrbysco.forcecraft.items.tools.ForceShearsItem;
import com.mrbysco.forcecraft.items.tools.ForceShovelItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;

public class ToolModStorage
implements Capability.IStorage<IToolModifier> {
    public static void attachInformation(ItemStack stack, List<ITextComponent> tooltip) {
        stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).ifPresent(cap -> {
            Item item = stack.func_77973_b();
            if (cap.getSpeedLevel() > 0 && (item instanceof ForceBowItem || item instanceof ForceArmorItem || item instanceof ForceRodItem)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.infuser.tooltip.speed" + cap.getSpeedLevel()).func_240699_a_(TextFormatting.YELLOW));
            }
            if (cap.hasLumberjack()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.infuser.tooltip.lumberjack").func_240699_a_(TextFormatting.YELLOW));
            }
            if (cap.getLuckLevel() > 0 && (item instanceof ForceBowItem || item instanceof ForceArmorItem)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.infuser.tooltip.luck" + cap.getLuckLevel()).func_240699_a_(TextFormatting.GREEN));
            }
            if (cap.getBaneLevel() > 0) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.infuser.tooltip.bane").func_240699_a_(TextFormatting.LIGHT_PURPLE));
            }
            if (cap.getSturdyLevel() > 0 && stack.func_77973_b() instanceof ForceArmorItem) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.infuser.tooltip.sturdy" + cap.getSturdyLevel()).func_240699_a_(TextFormatting.DARK_PURPLE));
            }
            if (cap.hasWing()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.infuser.tooltip.wing"));
            }
            if (cap.hasBleed()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.infuser.tooltip.bleed" + cap.getBleedLevel()).func_240699_a_(TextFormatting.RED));
            }
            if (cap.hasRainbow()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.infuser.tooltip.rainbow").func_240699_a_(TextFormatting.GOLD));
            }
            if (cap.hasHeat() && (item instanceof ForceShovelItem || item instanceof ForcePickaxeItem || item instanceof ForceShearsItem || item instanceof ForceArmorItem)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.infuser.tooltip.heat").func_240699_a_(TextFormatting.RED));
            }
            if (cap.hasCamo()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.infuser.tooltip.camo").func_240699_a_(TextFormatting.DARK_GREEN));
            }
            if (cap.hasEnder()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.infuser.tooltip.ender").func_240699_a_(TextFormatting.DARK_PURPLE));
            }
            if (cap.hasFreezing()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.infuser.tooltip.freezing").func_240699_a_(TextFormatting.BLUE));
            }
            if (cap.hasTreasure()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.infuser.tooltip.treasure").func_240699_a_(TextFormatting.GOLD));
            }
            if (cap.hasLight()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.infuser.tooltip.light").func_240699_a_(TextFormatting.GOLD));
            }
            if (cap.hasSharp() && stack.func_77973_b() instanceof ForceArmorItem) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.infuser.tooltip.sharp").func_240699_a_(TextFormatting.GOLD));
            }
        });
    }

    @Nullable
    public INBT writeNBT(Capability<IToolModifier> capability, IToolModifier instance, Direction side) {
        CompoundNBT nbt = ToolModStorage.serializeNBT(instance);
        return nbt;
    }

    public void readNBT(Capability<IToolModifier> capability, IToolModifier instance, Direction side, INBT nbtIn) {
        ToolModStorage.deserializeNBT(instance, nbtIn);
    }

    public static CompoundNBT serializeNBT(IToolModifier instance) {
        if (instance == null) {
            return null;
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("speed", instance.getSpeedLevel());
        nbt.func_74757_a("heat", instance.hasHeat());
        nbt.func_74768_a("force", instance.getForceLevel());
        nbt.func_74757_a("silk", instance.hasSilk());
        nbt.func_74768_a("sharp", instance.getSharpLevel());
        nbt.func_74768_a("luck", instance.getLuckLevel());
        nbt.func_74768_a("sturdy", instance.getSturdyLevel());
        nbt.func_74757_a("rainbow", instance.hasRainbow());
        nbt.func_74757_a("lumber", instance.hasLumberjack());
        nbt.func_74768_a("bleed", instance.getBleedLevel());
        nbt.func_74768_a("bane", instance.getBaneLevel());
        nbt.func_74757_a("wing", instance.hasWing());
        nbt.func_74757_a("camo", instance.hasCamo());
        nbt.func_74757_a("sight", instance.hasSight());
        nbt.func_74757_a("light", instance.hasLight());
        nbt.func_74757_a("ender", instance.hasEnder());
        nbt.func_74757_a("freezing", instance.hasFreezing());
        nbt.func_74757_a("treasure", instance.hasTreasure());
        return nbt;
    }

    public static void deserializeNBT(IToolModifier instance, INBT nbtIn) {
        if (nbtIn instanceof CompoundNBT) {
            CompoundNBT nbt = (CompoundNBT)nbtIn;
            instance.setSpeed(nbt.func_74762_e("speed"));
            instance.setHeat(nbt.func_74767_n("heat"));
            instance.setForce(nbt.func_74762_e("force"));
            instance.setSilk(nbt.func_74767_n("silk"));
            instance.setSharp(nbt.func_74762_e("sharp"));
            instance.setLuck(nbt.func_74762_e("luck"));
            instance.setSturdy(nbt.func_74762_e("sturdy"));
            instance.setRainbow(nbt.func_74767_n("rainbow"));
            instance.setLumberjack(nbt.func_74767_n("lumber"));
            instance.setBleed(nbt.func_74762_e("bleed"));
            instance.setBane(nbt.func_74762_e("bane"));
            instance.setWing(nbt.func_74767_n("wing"));
            instance.setCamo(nbt.func_74767_n("camo"));
            instance.setSight(nbt.func_74767_n("sight"));
            instance.setLight(nbt.func_74767_n("light"));
            instance.setEnder(nbt.func_74767_n("ender"));
            instance.setFreezing(nbt.func_74767_n("freezing"));
            instance.setTreasure(nbt.func_74767_n("treasure"));
        }
    }
}

