/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.capablilities.pack;

import com.mrbysco.forcecraft.items.ForcePackItem;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookData;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookTier;
import com.mrbysco.forcecraft.registry.ForceTags;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.items.ItemStackHandler;

public class PackItemStackHandler
extends ItemStackHandler {
    private static final int SLOTS_PER_UPGRADE = 8;
    private static final int MAX_UPGRADES = 4;
    public static final String NBT_UPGRADES = "Upgrades";
    private int upgrades;

    public PackItemStackHandler() {
        super(40);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return !(stack.func_77973_b() instanceof ForcePackItem) && !stack.func_77973_b().func_206844_a(ForceTags.HOLDS_ITEMS) && super.isItemValid(slot, stack);
    }

    public int getSlotsInUse() {
        return (this.upgrades + 1) * 8;
    }

    public int getUpgrades() {
        return this.upgrades;
    }

    public void setUpgrades(int upgrades) {
        this.upgrades = upgrades;
    }

    public void applyUpgrade() {
        ++this.upgrades;
        this.forceUpdate();
    }

    public void applyUpgrade(int upgrades) {
        this.upgrades += upgrades;
        this.forceUpdate();
    }

    public void applydowngrade() {
        --this.upgrades;
        this.forceUpdate();
    }

    public void applydowngrade(int upgrades) {
        this.upgrades -= upgrades;
        this.forceUpdate();
    }

    public void forceUpdate() {
        if (this.upgrades > 4) {
            this.upgrades = 4;
        }
        if (this.upgrades < 0) {
            this.upgrades = 0;
        }
        CompoundNBT tag = this.serializeNBT();
        this.deserializeNBT(tag);
    }

    public boolean canUpgrade(UpgradeBookData bd) {
        if (this.upgrades >= 4) {
            return false;
        }
        if (bd.getTier().asInt() >= UpgradeBookTier.TWO.asInt() && this.upgrades == 0) {
            return true;
        }
        if (bd.getTier().asInt() >= UpgradeBookTier.THREE.asInt() && this.upgrades == 1) {
            return true;
        }
        if (bd.getTier().asInt() >= UpgradeBookTier.FOUR.asInt() && this.upgrades == 2) {
            return true;
        }
        return bd.getTier().asInt() >= UpgradeBookTier.FIVE.asInt() && this.upgrades == 3;
    }

    public CompoundNBT serializeNBT() {
        ListNBT nbtTagList = new ListNBT();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).func_190926_b()) continue;
            CompoundNBT itemTag = new CompoundNBT();
            itemTag.func_74768_a("Slot", i);
            ((ItemStack)this.stacks.get(i)).func_77955_b(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Items", (INBT)nbtTagList);
        nbt.func_74768_a(NBT_UPGRADES, this.upgrades);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.setUpgrades(nbt.func_150297_b(NBT_UPGRADES, 3) ? nbt.func_74762_e(NBT_UPGRADES) : this.upgrades);
        ListNBT tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)ItemStack.func_199557_a((CompoundNBT)itemTags));
        }
        this.onLoad();
    }
}

