/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.capablilities.pack;

import com.mrbysco.forcecraft.capablilities.pack.PackItemStackHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class PackInventoryProvider
implements ICapabilitySerializable<CompoundNBT> {
    private final LazyOptional<PackItemStackHandler> inventory = LazyOptional.of(() -> new PackItemStackHandler());

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        if (this.inventory.isPresent()) {
            return ((PackItemStackHandler)((Object)this.inventory.resolve().get())).serializeNBT();
        }
        return new CompoundNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.inventory.ifPresent(h -> h.deserializeNBT(nbt));
    }
}

