/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.capablilities.forcewrench;

import com.mrbysco.forcecraft.capablilities.CapabilityHandler;
import com.mrbysco.forcecraft.capablilities.forcewrench.IForceWrench;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;

public class ForceWrenchStorage
implements Capability.IStorage<IForceWrench> {
    public static void attachInformation(ItemStack stack, List<ITextComponent> tooltip) {
        ForceToolData fd = new ForceToolData(stack);
        fd.attachInformation(tooltip);
        stack.getCapability(CapabilityHandler.CAPABILITY_FORCEWRENCH).ifPresent(cap -> {
            if (cap.getStoredName() != null && !cap.getStoredName().isEmpty()) {
                tooltip.add((ITextComponent)new StringTextComponent("Stored: ").func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)new TranslationTextComponent(cap.getStoredName()).func_240699_a_(TextFormatting.GRAY)));
            }
        });
    }

    @Nullable
    public INBT writeNBT(Capability<IForceWrench> capability, IForceWrench instance, Direction side) {
        CompoundNBT nbt = ForceWrenchStorage.serializeNBT(instance);
        return nbt;
    }

    public void readNBT(Capability<IForceWrench> capability, IForceWrench instance, Direction side, INBT nbtIn) {
        ForceWrenchStorage.deserializeNBT(instance, nbtIn);
    }

    public static CompoundNBT serializeNBT(IForceWrench instance) {
        if (instance == null) {
            return null;
        }
        CompoundNBT nbt = new CompoundNBT();
        if (instance.getStoredBlockNBT() != null) {
            nbt.func_218657_a("storedNBT", (INBT)instance.getStoredBlockNBT());
        }
        if (instance.getStoredBlockState() != null) {
            nbt.func_218657_a("storedBlockState", (INBT)NBTUtil.func_190009_a((BlockState)instance.getStoredBlockState()));
        }
        if (!instance.getStoredName().isEmpty()) {
            nbt.func_74778_a("name", instance.getStoredName());
        }
        return nbt;
    }

    public static void deserializeNBT(IForceWrench instance, INBT nbtIn) {
        if (nbtIn instanceof CompoundNBT) {
            CompoundNBT nbt = (CompoundNBT)nbtIn;
            instance.storeBlockNBT(nbt.func_74775_l("storedNBT"));
            if (nbt.func_74764_b("storedBlockState")) {
                instance.storeBlockState(NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("storedBlockState")));
            }
            instance.setBlockName(nbt.func_74779_i("name"));
        }
    }
}

