/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.capablilities.forcerod;

import com.mrbysco.forcecraft.capablilities.CapabilityHandler;
import com.mrbysco.forcecraft.capablilities.forcerod.IForceRodModifier;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;

public class ForceRodStorage
implements Capability.IStorage<IForceRodModifier> {
    public static void attachInformation(ItemStack stack, List<ITextComponent> tooltip) {
        stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).ifPresent(cap -> {
            if (cap.hasHealing()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.infuser.tooltip.healing" + cap.getHealingLevel()).func_240699_a_(TextFormatting.RED));
            }
            if (cap.getSpeedLevel() > 0) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.infuser.tooltip.speed" + cap.getSpeedLevel()));
            }
            if (cap.hasCamoModifier()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.infuser.tooltip.camo").func_240699_a_(TextFormatting.DARK_GREEN));
            }
            if (cap.hasEnderModifier()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.infuser.tooltip.ender").func_240699_a_(TextFormatting.DARK_PURPLE));
                if (cap.getHomeLocation() != null) {
                    GlobalPos globalPos = cap.getHomeLocation();
                    BlockPos pos = globalPos.func_218180_b();
                    tooltip.add((ITextComponent)new TranslationTextComponent("forcecraft.ender_rod.location", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), globalPos.func_239646_a_().func_240901_a_()}).func_240699_a_(TextFormatting.YELLOW));
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent("forcecraft.ender_rod.unset").func_240699_a_(TextFormatting.RED));
                }
                tooltip.add((ITextComponent)new TranslationTextComponent("forcecraft.ender_rod.text").func_240699_a_(TextFormatting.GRAY));
            }
            if (cap.hasSightModifier()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.infuser.tooltip.sight").func_240699_a_(TextFormatting.LIGHT_PURPLE));
            }
            if (cap.hasLight()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.infuser.tooltip.light").func_240699_a_(TextFormatting.YELLOW));
            }
        });
    }

    @Nullable
    public INBT writeNBT(Capability<IForceRodModifier> capability, IForceRodModifier instance, Direction side) {
        CompoundNBT nbt = ForceRodStorage.serializeNBT(instance);
        return nbt;
    }

    public void readNBT(Capability<IForceRodModifier> capability, IForceRodModifier instance, Direction side, INBT nbtIn) {
        ForceRodStorage.deserializeNBT(instance, nbtIn);
    }

    public static CompoundNBT serializeNBT(IForceRodModifier instance) {
        if (instance == null) {
            return null;
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("speed", instance.getSpeedLevel());
        nbt.func_74768_a("healing", instance.getHealingLevel());
        if (instance.getHomeLocation() != null) {
            nbt.func_74757_a("HasHome", true);
            nbt.func_74772_a("HomeLocation", instance.getHomeLocation().func_218180_b().func_218275_a());
            nbt.func_74778_a("HomeDimension", instance.getHomeLocation().func_239646_a_().func_240901_a_().toString());
        }
        nbt.func_74757_a("camo", instance.hasCamoModifier());
        nbt.func_74757_a("ender", instance.hasEnderModifier());
        nbt.func_74757_a("sight", instance.hasSightModifier());
        nbt.func_74757_a("light", instance.hasLight());
        return nbt;
    }

    public static void deserializeNBT(IForceRodModifier instance, INBT nbtIn) {
        if (nbtIn instanceof CompoundNBT) {
            CompoundNBT nbt = (CompoundNBT)nbtIn;
            instance.setSpeed(nbt.func_74762_e("speed"));
            instance.setHealing(nbt.func_74762_e("healing"));
            if (nbt.func_74767_n("HasHome")) {
                BlockPos pos = BlockPos.func_218283_e((long)nbt.func_74763_f("HomeLocation"));
                ResourceLocation location = ResourceLocation.func_208304_a((String)nbt.func_74779_i("HomeDimension"));
                if (location != null) {
                    RegistryKey dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)location);
                    instance.setHomeLocation(GlobalPos.func_239648_a_((RegistryKey)dimension, (BlockPos)pos));
                }
            }
            instance.setCamoModifier(nbt.func_74767_n("camo"));
            instance.setEnderModifier(nbt.func_74767_n("ender"));
            instance.setSightModifier(nbt.func_74767_n("sight"));
            instance.setLight(nbt.func_74767_n("light"));
        }
    }
}

