/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.capablilities;

import com.mrbysco.forcecraft.capablilities.CapabilityHandler;
import com.mrbysco.forcecraft.capablilities.banemodifier.BaneProvider;
import com.mrbysco.forcecraft.capablilities.playermodifier.IPlayerModifier;
import com.mrbysco.forcecraft.capablilities.playermodifier.PlayerModifierProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CapabilityAttachHandler {
    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EndermanEntity || event.getObject() instanceof CreeperEntity) {
            event.addCapability(CapabilityHandler.BANE_CAP, (ICapabilityProvider)new BaneProvider());
        }
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(CapabilityHandler.PLAYER_CAP, (ICapabilityProvider)new PlayerModifierProvider());
        }
    }

    @SubscribeEvent
    public void onDeath(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        PlayerEntity original = event.getOriginal();
        PlayerEntity clone = event.getPlayer();
        Capability<IPlayerModifier> capability = CapabilityHandler.CAPABILITY_PLAYERMOD;
        original.getCapability(capability).ifPresent(dataOriginal -> clone.getCapability(capability).ifPresent(dataClone -> {
            INBT nbt = capability.getStorage().writeNBT(capability, dataOriginal, null);
            capability.getStorage().readNBT(capability, dataClone, null, nbt);
        }));
    }
}

