/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blocks.infuser;

import com.mrbysco.forcecraft.blocks.infuser.InfuserContainer;
import com.mrbysco.forcecraft.blocks.infuser.InfuserModifierType;
import com.mrbysco.forcecraft.capablilities.CapabilityHandler;
import com.mrbysco.forcecraft.capablilities.forcerod.IForceRodModifier;
import com.mrbysco.forcecraft.capablilities.pack.PackItemStackHandler;
import com.mrbysco.forcecraft.capablilities.toolmodifier.IToolModifier;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.items.ForceArmorItem;
import com.mrbysco.forcecraft.items.ForcePackItem;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookData;
import com.mrbysco.forcecraft.items.infuser.UpgradeTomeItem;
import com.mrbysco.forcecraft.items.tools.ForceAxeItem;
import com.mrbysco.forcecraft.items.tools.ForceBowItem;
import com.mrbysco.forcecraft.items.tools.ForcePickaxeItem;
import com.mrbysco.forcecraft.items.tools.ForceRodItem;
import com.mrbysco.forcecraft.items.tools.ForceShearsItem;
import com.mrbysco.forcecraft.items.tools.ForceShovelItem;
import com.mrbysco.forcecraft.items.tools.ForceSwordItem;
import com.mrbysco.forcecraft.networking.PacketHandler;
import com.mrbysco.forcecraft.networking.message.StopInfuserSoundMessage;
import com.mrbysco.forcecraft.recipe.ForceRecipes;
import com.mrbysco.forcecraft.recipe.InfuseRecipe;
import com.mrbysco.forcecraft.registry.ForceFluids;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.registry.ForceSounds;
import com.mrbysco.forcecraft.registry.ForceTags;
import com.mrbysco.forcecraft.tiles.energy.ForceEnergyStorage;
import com.mrbysco.forcecraft.util.EnchantUtils;
import com.mrbysco.forcecraft.util.ItemHandlerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class InfuserTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider,
IInventory {
    private static final int FLUID_CHARGE = 1000;
    public boolean canWork = false;
    public boolean makesSpecialSound = false;
    public int processTime = 0;
    public int maxProcessTime = 20;
    public static final int SLOT_TOOL = 8;
    public static final int SLOT_GEM = 9;
    public static final int SLOT_BOOK = 10;
    public static final int ENERGY_COST_PER = 20;
    public static final int FLUID_COST_PER = 1000;
    private static final int FLUID_PER_GEM = 500;
    protected Map<Integer, InfuseRecipe> currentRecipes = new HashMap<Integer, InfuseRecipe>();
    protected FluidTank tank = new FluidTank(50000){

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!InfuserTileEntity.this.isFluidEqual(resource)) {
                return FluidStack.EMPTY;
            }
            if (action.simulate()) {
                int amount = InfuserTileEntity.this.tank.getFluidAmount() - resource.getAmount() < 0 ? InfuserTileEntity.this.tank.getFluidAmount() : resource.getAmount();
                return new FluidStack(InfuserTileEntity.this.tank.getFluid(), amount);
            }
            return super.drain(resource.getAmount(), action);
        }

        protected void onContentsChanged() {
            InfuserTileEntity.this.refreshClient();
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return super.drain(maxDrain, action);
        }

        public boolean isFluidValid(FluidStack stack) {
            for (Fluid fluid : FluidTags.func_226157_a_().func_199910_a(new ResourceLocation("forge", "force")).func_230236_b_()) {
                if (fluid != stack.getFluid()) continue;
                return true;
            }
            return false;
        }
    };
    private LazyOptional<IFluidHandler> tankHolder = LazyOptional.of(() -> this.tank);
    public final ItemStackHandler handler = new ItemStackHandler(11){

        protected int getStackLimit(int slot, ItemStack stack) {
            if (slot == 9) {
                return 64;
            }
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot < 8) {
                return InfuserTileEntity.this.matchesModifier(stack);
            }
            if (slot == 8) {
                return InfuserTileEntity.this.matchesTool(stack);
            }
            if (slot == 10) {
                return stack.func_77973_b() == ForceRegistry.UPGRADE_TOME.get();
            }
            if (slot == 9) {
                return stack.func_77973_b() == ForceRegistry.FORCE_GEM.get();
            }
            return true;
        }
    };
    private LazyOptional<IItemHandler> handlerHolder = LazyOptional.of(() -> this.handler);
    public ForceEnergyStorage energyStorage = new ForceEnergyStorage(64000, 1000);
    private LazyOptional<ForceEnergyStorage> energyHolder = LazyOptional.of(() -> this.energyStorage);
    private NonNullList<ItemStack> infuserContents = NonNullList.func_191196_a();

    public InfuserTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public InfuserTileEntity() {
        this((TileEntityType)ForceRegistry.INFUSER_TILE.get());
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        this.processTime = nbt.func_74762_e("processTime");
        this.maxProcessTime = nbt.func_74762_e("maxProcessTime");
        this.canWork = nbt.func_74767_n("canWork");
        this.handler.deserializeNBT(nbt.func_74775_l("ItemStackHandler"));
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.infuserContents);
        this.energyStorage.setEnergy(nbt.func_74762_e("EnergyHandler"));
        this.tank.readFromNBT(nbt);
        super.func_230337_a_(state, nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a("processTime", this.processTime);
        compound.func_74768_a("maxProcessTime", this.maxProcessTime);
        compound.func_74757_a("canWork", this.canWork);
        compound.func_218657_a("ItemStackHandler", (INBT)this.handler.serializeNBT());
        compound.func_74768_a("EnergyHandler", this.energyStorage.getEnergyStored());
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.infuserContents);
        this.tank.writeToNBT(compound);
        return compound;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.handler.getStackInSlot(9).func_77973_b() == ForceRegistry.FORCE_GEM.get()) {
            this.processForceGems();
        }
        if (this.canWork) {
            ++this.processTime;
            if (this.field_145850_b.func_82737_E() % 60L == 0L) {
                this.makeWorkSound();
            }
            if (this.energyStorage.getEnergyStored() > 20) {
                this.energyStorage.consumePower(20);
            }
            if (this.processTime < this.maxProcessTime) {
                return;
            }
            this.processTime = 0;
            if (this.isWorkAllowed()) {
                if (this.areAllModifiersEmpty() && this.canCharge()) {
                    this.processForceCharging();
                } else if (this.recipesStillMatch()) {
                    this.processTool();
                }
                this.stopWorkSound();
                if (this.makesSpecialSound) {
                    this.playSound((SoundEvent)ForceSounds.INFUSER_SPECIAL_DONE.get(), 1.0f, 1.0f);
                } else {
                    this.playSound((SoundEvent)ForceSounds.INFUSER_DONE.get(), 1.0f, 1.0f);
                }
                this.makesSpecialSound = false;
            }
            this.canWork = false;
            this.processTime = 0;
            this.refreshClient();
        } else {
            this.processTime = 0;
        }
    }

    public void startWork() {
        this.canWork = true;
        this.processTime = 0;
        this.setMaxTimeFromRecipes();
        if (this.areAllModifiersEmpty() && this.canCharge()) {
            this.maxProcessTime = (Integer)ConfigHandler.COMMON.forceInfusingTime.get();
        }
        if (this.maxProcessTime <= 0) {
            this.canWork = false;
            this.maxProcessTime = 0;
        }
        if (this.canWork) {
            this.stopWorkSound();
            this.makesSpecialSound = false;
            if (this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                this.makesSpecialSound = true;
                this.playSound((SoundEvent)ForceSounds.INFUSER_SPECIAL_BEEP.get(), 1.0f, 1.0f);
            }
            this.makeWorkSound();
        }
        this.refreshClient();
    }

    public void makeWorkSound() {
        if (this.makesSpecialSound) {
            this.playSound((SoundEvent)ForceSounds.INFUSER_SPECIAL.get(), 1.0f, 1.0f);
        } else {
            this.playSound((SoundEvent)ForceSounds.INFUSER_WORKING.get(), 1.0f, 1.0f);
        }
    }

    public void playSound(SoundEvent event, float volume, float pitch) {
        BlockPos pos = this.func_174877_v();
        this.field_145850_b.func_184148_a((PlayerEntity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), event, SoundCategory.BLOCKS, volume, pitch);
    }

    public void stopWorkSound() {
        if (!this.field_145850_b.field_72995_K) {
            BlockPos pos = this.func_174877_v();
            for (PlayerEntity playerentity : this.field_145850_b.func_217369_A()) {
                if (!(playerentity.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) < 200.0)) continue;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)playerentity), (Object)new StopInfuserSoundMessage());
            }
        }
    }

    private void setMaxTimeFromRecipes() {
        ArrayList<InfuseRecipe> recipes;
        this.maxProcessTime = 0;
        if (!this.getBookInSlot().func_190926_b() && !(recipes = new ArrayList<InfuseRecipe>(this.getMatchingRecipes().values())).isEmpty()) {
            for (InfuseRecipe recipeCurrent : recipes) {
                this.maxProcessTime += recipeCurrent.getTime();
            }
        }
    }

    protected Map<Integer, InfuseRecipe> getMatchingRecipes() {
        if (this.getBookInSlot().func_190926_b()) {
            return new HashMap<Integer, InfuseRecipe>();
        }
        if (!this.currentRecipes.isEmpty() && this.recipesStillMatch()) {
            return this.currentRecipes;
        }
        HashMap<Integer, InfuseRecipe> matchingRecipes = new HashMap<Integer, InfuseRecipe>();
        block0: for (int i = 0; i < 8; ++i) {
            ItemStack modifier = this.getModifier(i);
            if (modifier.func_190926_b()) continue;
            List recipes = this.field_145850_b.func_199532_z().func_241447_a_(ForceRecipes.INFUSER_TYPE);
            for (InfuseRecipe recipe : recipes) {
                if (!recipe.matchesModifier(this, modifier, false)) continue;
                matchingRecipes.put(i, recipe);
                continue block0;
            }
        }
        this.currentRecipes = matchingRecipes;
        return this.currentRecipes;
    }

    protected boolean matchesModifier(ItemStack stack) {
        if (this.field_145850_b != null) {
            List recipes = this.field_145850_b.func_199532_z().func_241447_a_(ForceRecipes.INFUSER_TYPE);
            for (InfuseRecipe recipe : recipes) {
                if (!recipe.matchesModifier(this, stack)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean matchesTool(ItemStack toolStack) {
        if (this.field_145850_b != null) {
            List recipes = this.field_145850_b.func_199532_z().func_241447_a_(ForceRecipes.INFUSER_TYPE);
            for (InfuseRecipe recipe : recipes) {
                if (!recipe.matchesTool(toolStack, true)) continue;
                return true;
            }
        }
        return toolStack.func_77973_b().func_206844_a(ForceTags.VALID_INFUSER_CHARGE);
    }

    protected boolean recipesStillMatch() {
        for (Map.Entry<Integer, InfuseRecipe> entry : this.currentRecipes.entrySet()) {
            ItemStack modifier = this.getModifier(entry.getKey());
            if (entry.getValue().matchesModifier(this, modifier, false)) continue;
            return false;
        }
        return true;
    }

    private void refreshClient() {
        this.func_70296_d();
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
    }

    private void processForceGems() {
        FluidStack force = new FluidStack((Fluid)ForceFluids.FORCE_FLUID_SOURCE.get(), 500);
        if (this.tank.getFluidAmount() + force.getAmount() <= this.tank.getCapacity()) {
            this.fill(force, IFluidHandler.FluidAction.EXECUTE);
            this.handler.getStackInSlot(9).func_190918_g(1);
            this.refreshClient();
        }
    }

    public boolean areAllModifiersEmpty() {
        int emptySlots = 0;
        for (int i = 0; i < 8; ++i) {
            if (!this.handler.getStackInSlot(i).func_190926_b()) continue;
            ++emptySlots;
        }
        return emptySlots == 8;
    }

    private void processForceCharging() {
        ItemStack tool = this.getFromToolSlot();
        ForceToolData force = new ForceToolData(tool);
        int charge = 1000;
        if (tool.func_77951_h()) {
            int ratio = 25;
            int damage = tool.func_77952_i();
            int repaired = 0;
            for (int i = 0; i < damage; ++i) {
                if (charge < 25) continue;
                ++repaired;
                charge -= 25;
            }
            tool.func_196085_b(damage - repaired);
        }
        if (charge > 0) {
            force.charge(charge);
        }
        this.tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        force.write(tool);
    }

    private void processTool() {
        for (Map.Entry<Integer, InfuseRecipe> entry : this.currentRecipes.entrySet()) {
            ItemStack tool;
            boolean success;
            ItemStack modifier = this.getModifier(entry.getKey());
            InfuseRecipe recipe = entry.getValue();
            if (!recipe.matchesModifier(this, modifier, true) || !(success = this.applyModifier(tool = this.getFromToolSlot(), modifier, recipe))) continue;
            modifier.func_190918_g(1);
            this.tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            UpgradeTomeItem.onModifierApplied(this.getBookInSlot(), modifier, tool);
        }
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public CompoundNBT getTileData() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handlerHolder.cast();
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tankHolder.cast();
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return this.energyHolder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public boolean hasTool() {
        ItemStack tool = this.getFromToolSlot();
        return !tool.func_190926_b();
    }

    public boolean hasValidBook() {
        ItemStack tool = this.getBookInSlot();
        if (!tool.func_190926_b()) {
            return tool.func_77973_b() == ForceRegistry.UPGRADE_TOME.get();
        }
        return false;
    }

    public ItemStack getFromToolSlot() {
        return this.handler.getStackInSlot(8);
    }

    public ItemStack getBookInSlot() {
        return this.handler.getStackInSlot(10);
    }

    public ItemStack getModifier(int slot) {
        if (slot >= 0 && slot <= 7) {
            return this.handler.getStackInSlot(slot);
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasValidModifer(int slot) {
        return !this.getModifier(slot).func_190926_b();
    }

    public boolean canCharge() {
        ItemStack tool = this.getFromToolSlot();
        return this.isValidChargeableStack(tool) && this.tank.getFluidAmount() > 1000;
    }

    public boolean isValidChargeableStack(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        return stack.func_77973_b().func_206844_a(ForceTags.VALID_INFUSER_CHARGE) && tag != null && tag.func_74764_b("ForceInfused") && stack.func_190916_E() == 1;
    }

    private boolean applyModifier(ItemStack tool, ItemStack modifier, InfuseRecipe recipe) {
        UpgradeBookData bd = new UpgradeBookData(this.getBookInSlot());
        if (recipe.resultModifier.apply(tool, modifier, bd)) {
            bd.onRecipeApply(recipe, this.getBookInSlot());
            if (recipe.resultModifier == InfuserModifierType.ITEM && recipe.hasOutput()) {
                this.handler.setStackInSlot(8, recipe.func_77571_b().func_77946_l());
            } else {
                this.handler.setStackInSlot(8, tool);
            }
            return true;
        }
        return false;
    }

    static boolean applyCamo(ItemStack tool, ItemStack mod) {
        List effects = PotionUtils.func_185189_a((ItemStack)mod);
        for (EffectInstance e : effects) {
            if (e.func_188419_a() == Effects.field_76439_r) {
                return InfuserTileEntity.addSightModifier(tool);
            }
            if (e.func_188419_a() != Effects.field_76441_p) continue;
            return InfuserTileEntity.addCamoModifier(tool);
        }
        return false;
    }

    static boolean addLightModifier(ItemStack stack) {
        IToolModifier modifierCap;
        Item item = stack.func_77973_b();
        if (item instanceof ForceRodItem) {
            IForceRodModifier rodCap = (IForceRodModifier)stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).orElse(null);
            if (rodCap != null && !rodCap.hasLight()) {
                rodCap.setLight(true);
                InfuserTileEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceBowItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && !modifierCap.hasLight()) {
            modifierCap.setLight(true);
            InfuserTileEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    private static boolean addCamoModifier(ItemStack stack) {
        IToolModifier toolCap;
        Item item = stack.func_77973_b();
        if (item instanceof ForceRodItem) {
            IForceRodModifier rodCap = (IForceRodModifier)stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).orElse(null);
            if (rodCap != null && !rodCap.hasCamoModifier()) {
                rodCap.setCamoModifier(true);
                InfuserTileEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && (toolCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && !toolCap.hasCamo()) {
            toolCap.setCamo(true);
            InfuserTileEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    private static boolean addSightModifier(ItemStack stack) {
        IForceRodModifier rodCap;
        if (stack.func_77973_b() instanceof ForceRodItem && (rodCap = (IForceRodModifier)stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).orElse(null)) != null && !rodCap.hasSightModifier()) {
            rodCap.setSightModifier(true);
            InfuserTileEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addWingModifier(ItemStack stack) {
        IToolModifier modifierCap;
        Item item = stack.func_77973_b();
        if (item instanceof ForceSwordItem) {
            IToolModifier modifierCap2 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap2 != null && !modifierCap2.hasWing()) {
                modifierCap2.setWing(true);
                InfuserTileEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && !modifierCap.hasWing()) {
            modifierCap.setWing(true);
            InfuserTileEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addBaneModifier(ItemStack stack) {
        IToolModifier modifierCap;
        Item item = stack.func_77973_b();
        if (item instanceof ForceSwordItem) {
            IToolModifier modifierCap2 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap2 != null && !modifierCap2.hasBane()) {
                modifierCap2.setBane(1);
                InfuserTileEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceBowItem) {
            IToolModifier modifierCap3 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap3 != null && !modifierCap3.hasBane()) {
                modifierCap3.setBane(1);
                InfuserTileEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && modifierCap != null && !modifierCap.hasBane()) {
            modifierCap.setBane(1);
            InfuserTileEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addBleedingModifier(ItemStack stack) {
        IToolModifier modifierCap;
        Item item = stack.func_77973_b();
        int MAX_CAP = (Integer)ConfigHandler.COMMON.bleedCap.get();
        if (item instanceof ForceSwordItem) {
            IToolModifier modifierCap2 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap2 != null && modifierCap2.getBleedLevel() < MAX_CAP) {
                modifierCap2.incrementBleed();
                InfuserTileEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceBowItem) {
            IToolModifier modifierCap3 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap3 != null && modifierCap3.getBleedLevel() < MAX_CAP) {
                modifierCap3.incrementBleed();
                InfuserTileEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && modifierCap.getBleedLevel() < MAX_CAP) {
            modifierCap.incrementBleed();
            InfuserTileEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addEnderModifier(ItemStack stack) {
        IToolModifier modifierCap;
        Item item = stack.func_77973_b();
        if (item instanceof ForceRodItem) {
            IForceRodModifier rodCap = (IForceRodModifier)stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).orElse(null);
            if (rodCap != null && !rodCap.isRodofEnder()) {
                rodCap.setEnderModifier(true);
                InfuserTileEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceSwordItem) {
            IToolModifier modifierCap2 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap2 != null && !modifierCap2.hasEnder()) {
                modifierCap2.setEnder(true);
                InfuserTileEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceBowItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && !modifierCap.hasEnder()) {
            modifierCap.setEnder(true);
            InfuserTileEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addFreezingModifier(ItemStack stack) {
        IToolModifier modifierCap;
        if (stack.func_77973_b() instanceof ForceBowItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && !modifierCap.hasFreezing()) {
            modifierCap.setFreezing(true);
            InfuserTileEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addHealingModifier(ItemStack stack) {
        IForceRodModifier rodCap;
        if (stack.func_77973_b() instanceof ForceRodItem && (rodCap = (IForceRodModifier)stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).orElse(null)) != null) {
            int MAX_CAP = (Integer)ConfigHandler.COMMON.healingCap.get();
            if (rodCap.getHealingLevel() < MAX_CAP) {
                rodCap.incrementHealing();
                InfuserTileEntity.addInfusedTag(stack);
                return true;
            }
        }
        return false;
    }

    static boolean addLumberjackModifier(ItemStack stack) {
        IToolModifier modifierCap;
        if (stack.func_77973_b() instanceof ForceAxeItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && !modifierCap.hasLumberjack()) {
            modifierCap.setLumberjack(true);
            InfuserTileEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addRainbowModifier(ItemStack stack) {
        IToolModifier modifierCap;
        if (stack.func_77973_b() instanceof ForceShearsItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null) {
            modifierCap.setRainbow(true);
            InfuserTileEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addTreasureModifier(ItemStack stack) {
        IToolModifier modifierCap;
        if ((stack.func_77973_b() instanceof ForceSwordItem || stack.func_77973_b() instanceof ForceAxeItem) && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && !modifierCap.hasTreasure()) {
            modifierCap.setTreasure(true);
            InfuserTileEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean upgradeBag(ItemStack stack, UpgradeBookData bd) {
        IItemHandler handler;
        if (stack.func_77973_b() instanceof ForcePackItem && (handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null)) instanceof PackItemStackHandler) {
            PackItemStackHandler packHandler = (PackItemStackHandler)handler;
            if (packHandler.canUpgrade(bd)) {
                packHandler.applyUpgrade();
                CompoundNBT tag = stack.func_196082_o();
                tag.func_74768_a("SlotsUsed", ItemHandlerUtils.getUsedSlots((IItemHandler)packHandler));
                tag.func_74768_a("BookTier", packHandler.getUpgrades());
                stack.func_77982_d(tag);
                return true;
            }
            return false;
        }
        return false;
    }

    static boolean addSturdyModifier(ItemStack stack) {
        IToolModifier modifierCap;
        Item item = stack.func_77973_b();
        if (item instanceof ForceSwordItem || item instanceof ForceAxeItem || item instanceof ForceShovelItem || item instanceof ForcePickaxeItem || item instanceof ForceRodItem) {
            IToolModifier modifierCap2 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap2 != null && modifierCap2.getSturdyLevel() < (Integer)ConfigHandler.COMMON.sturdyToolCap.get()) {
                modifierCap2.incrementSturdy();
                EnchantUtils.incrementLevel(stack, Enchantments.field_185307_s);
                InfuserTileEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && modifierCap.getSturdyLevel() == 0) {
            modifierCap.incrementSturdy();
            InfuserTileEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addLuckModifier(ItemStack stack) {
        IToolModifier modifierCap;
        Item item = stack.func_77973_b();
        int MAX_CAP = (Integer)ConfigHandler.COMMON.luckCap.get();
        if (item instanceof ForcePickaxeItem || item instanceof ForceShovelItem || item instanceof ForceAxeItem) {
            IToolModifier modifierCap2 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap2 != null && modifierCap2.getLuckLevel() < MAX_CAP) {
                modifierCap2.incrementLuck();
                EnchantUtils.incrementLevel(stack, Enchantments.field_185308_t);
                InfuserTileEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceSwordItem) {
            IToolModifier modifierCap3 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap3 != null && modifierCap3.getLuckLevel() < MAX_CAP) {
                modifierCap3.incrementLuck();
                EnchantUtils.incrementLevel(stack, Enchantments.field_185304_p);
                InfuserTileEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceBowItem) {
            IToolModifier modifierCap4 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap4 != null && modifierCap4.getLuckLevel() < MAX_CAP) {
                modifierCap4.incrementLuck();
                InfuserTileEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && modifierCap.getLuckLevel() < MAX_CAP) {
            modifierCap.incrementLuck();
            InfuserTileEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addDamageModifier(ItemStack stack) {
        IToolModifier modifierCap;
        Item item = stack.func_77973_b();
        int MAX_CAP = (Integer)ConfigHandler.COMMON.damageCap.get();
        if (item instanceof ForceSwordItem) {
            IToolModifier modifierCap2 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap2 != null && modifierCap2.getSharpLevel() < MAX_CAP) {
                modifierCap2.incrementSharp();
                EnchantUtils.incrementLevel(stack, Enchantments.field_185302_k);
                InfuserTileEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceBowItem) {
            IToolModifier modifierCap3 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap3 != null && modifierCap3.getSharpLevel() < MAX_CAP) {
                modifierCap3.incrementSharp();
                EnchantUtils.incrementLevel(stack, Enchantments.field_185309_u);
                InfuserTileEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && modifierCap.getSharpLevel() < 1) {
            modifierCap.incrementSharp();
            InfuserTileEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addSilkTouchModifier(ItemStack stack) {
        IToolModifier modifierCap;
        Item item = stack.func_77973_b();
        if ((item instanceof ForceAxeItem || item instanceof ForceShovelItem || item instanceof ForcePickaxeItem) && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && !modifierCap.hasSilk()) {
            modifierCap.setSilk(true);
            stack.func_77966_a(Enchantments.field_185306_r, 1);
            InfuserTileEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addForceModifier(ItemStack stack) {
        IToolModifier modifierCap;
        Item item = stack.func_77973_b();
        int MAX_CAP = (Integer)ConfigHandler.COMMON.forceCap.get();
        if ((item instanceof ForceSwordItem || item instanceof ForceAxeItem) && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && modifierCap.getForceLevel() < MAX_CAP) {
            modifierCap.incrementForce();
            EnchantUtils.incrementLevel(stack, Enchantments.field_180313_o);
            InfuserTileEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addHeatModifier(ItemStack stack) {
        IToolModifier modifierCap;
        Item item = stack.func_77973_b();
        if (item instanceof ForceShovelItem || item instanceof ForcePickaxeItem || item instanceof ForceShearsItem) {
            IToolModifier modifierCap2 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap2 != null && !modifierCap2.hasHeat()) {
                modifierCap2.setHeat(true);
                InfuserTileEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceSwordItem || item instanceof ForceAxeItem) {
            IToolModifier modifierCap3 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap3 != null && !modifierCap3.hasHeat()) {
                stack.func_77966_a(Enchantments.field_77334_n, 1);
                modifierCap3.setHeat(true);
                InfuserTileEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && (modifierCap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null && !modifierCap.hasHeat()) {
            modifierCap.setHeat(true);
            InfuserTileEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addSpeedModifier(ItemStack stack) {
        IForceRodModifier modifierCap;
        Item item = stack.func_77973_b();
        int MAX_CAP = (Integer)ConfigHandler.COMMON.speedCap.get();
        if (item instanceof ForceShovelItem || item instanceof ForcePickaxeItem || item instanceof ForceAxeItem) {
            IToolModifier modifierCap2 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap2 != null && modifierCap2.getSpeedLevel() < MAX_CAP) {
                modifierCap2.incrementSpeed();
                EnchantUtils.incrementLevel(stack, Enchantments.field_185305_q);
                InfuserTileEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceBowItem) {
            IToolModifier modifierCap3 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap3 != null && modifierCap3.getSpeedLevel() < 1) {
                modifierCap3.incrementSpeed();
                InfuserTileEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem) {
            IToolModifier modifierCap4 = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
            if (modifierCap4 != null && modifierCap4.getSpeedLevel() < 1) {
                modifierCap4.incrementSpeed();
                InfuserTileEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceRodItem && (modifierCap = (IForceRodModifier)stack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).orElse(null)) != null && modifierCap.getSpeedLevel() < (Integer)ConfigHandler.COMMON.rodSpeedCap.get()) {
            modifierCap.incrementSpeed();
            InfuserTileEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static void addInfusedTag(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (!tag.func_74764_b("ForceInfused")) {
            tag.func_74757_a("ForceInfused", true);
            stack.func_77982_d(tag);
        }
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack resourceCopy = resource.copy();
        if (action.execute() && (this.tank.getFluid().isEmpty() || this.tank.getFluid().isFluidEqual(resource))) {
            this.tank.fill(resourceCopy, action);
        }
        return resource.getAmount();
    }

    public Fluid getFluid() {
        if (!this.tank.isEmpty()) {
            return this.tank.getFluid().getFluid();
        }
        return null;
    }

    public FluidStack getFluidStack() {
        if (!this.tank.isEmpty()) {
            return this.tank.getFluid();
        }
        return null;
    }

    public boolean isWorkAllowed() {
        return this.hasTool() && this.hasValidBook();
    }

    public boolean hasValidRecipe() {
        return this.isWorkAllowed() && (this.areAllModifiersEmpty() && this.canCharge() || this.allSlotsMatchRecipe());
    }

    public boolean updateValidRecipe() {
        if (this.canWork) {
            this.canWork = false;
            this.processTime = 0;
            this.refreshClient();
        }
        return this.hasValidRecipe();
    }

    public boolean allSlotsMatchRecipe() {
        int requiredForce = 0;
        int requiredPower = 0;
        List recipes = this.field_145850_b.func_199532_z().func_241447_a_(ForceRecipes.INFUSER_TYPE);
        boolean foundMatch = false;
        for (InfuseRecipe recipe : recipes) {
            ItemStack centerStack = this.getFromToolSlot();
            int amountFound = 0;
            for (int i = 0; i < 8; ++i) {
                ItemStack modifier = this.getModifier(i);
                if (modifier.func_190926_b() || !recipe.matchesModifier(this, modifier, false)) continue;
                foundMatch = true;
                ++amountFound;
                requiredForce += 1000;
                requiredPower += recipe.getTime() * 20;
            }
            if (amountFound <= 0 || amountFound <= recipe.getModifier().getLevelCap(centerStack)) continue;
            return false;
        }
        if (!foundMatch) {
            return false;
        }
        return this.getFluidAmount() >= requiredForce && this.getEnergy() >= requiredPower;
    }

    public int getBookTier() {
        if (!this.getBookInSlot().func_190926_b()) {
            return new UpgradeBookData(this.getBookInSlot()).getTier().ordinal();
        }
        return 0;
    }

    public int getEnergyCostPer() {
        return 20;
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public void setFluidAmount(int amount) {
        if (amount > 0) {
            if (!this.tank.getFluid().isEmpty()) {
                this.tank.getFluid().setAmount(amount);
            }
        } else {
            this.tank.setFluid(FluidStack.EMPTY);
        }
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public void setEnergyStored(int energy) {
        this.energyStorage.setEnergy(energy);
    }

    public float getFluidPercentage() {
        return (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
    }

    protected boolean isFluidEqual(FluidStack fluid) {
        return this.isFluidEqual(fluid.getFluid());
    }

    protected boolean isFluidEqual(Fluid fluid) {
        return this.tank.getFluid().getFluid().equals(fluid);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("forcecraft.container.infuser");
    }

    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        return new InfuserContainer(id, playerInv, this);
    }

    public void func_174888_l() {
    }

    public ItemStack func_70298_a(int arg0, int arg1) {
        return ItemStack.field_190927_a;
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int arg0) {
        return ItemStack.field_190927_a;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    public ItemStack func_70304_b(int arg0) {
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int arg0, ItemStack arg1) {
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.tankHolder.invalidate();
        this.handlerHolder.invalidate();
        this.energyHolder.invalidate();
    }
}

