/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blocks.infuser;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrbysco.forcecraft.blocks.infuser.InfuserContainer;
import com.mrbysco.forcecraft.blocks.infuser.InfuserTileEntity;
import com.mrbysco.forcecraft.client.gui.widgets.ProgressBar;
import com.mrbysco.forcecraft.client.util.RenderHelper;
import com.mrbysco.forcecraft.compat.patchouli.PatchouliCompat;
import com.mrbysco.forcecraft.networking.PacketHandler;
import com.mrbysco.forcecraft.networking.message.InfuserMessage;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.network.PacketDistributor;
import org.lwjgl.opengl.GL11;

public class InfuserScreen
extends ContainerScreen<InfuserContainer> {
    private ProgressBar infuserProgress;
    private final ResourceLocation INFO = new ResourceLocation("forcecraft", "textures/gui/container/info.png");
    private final ResourceLocation ENERGY = new ResourceLocation("forcecraft", "textures/gui/container/energy.png");
    private final ResourceLocation TEXTURE = new ResourceLocation("forcecraft", "textures/gui/container/forceinfuser.png");
    private Button buttonInfuse;

    public InfuserScreen(InfuserContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.field_147000_g = 208;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.infuserProgress = new ProgressBar(this.TEXTURE, ProgressBar.ProgressBarDirection.DOWN_TO_UP, 2, 20, this.field_147003_i + 134, this.field_147009_r + 93, 176, 0);
        final int btnSize = 13;
        int x = 123;
        int y = 16;
        this.func_230480_a_((Widget)new Button(this.field_147003_i + x, this.field_147009_r + y, 13, 13, (ITextComponent)new TranslationTextComponent("gui.forcecraft.infuser.button.guide"), button -> {
            if (ModList.get().isLoaded("patchouli")) {
                PatchouliCompat.openBook();
            } else {
                this.field_213127_e.field_70458_d.func_146105_b((ITextComponent)new TranslationTextComponent("gui.forcecraft.infuser.patchouli"), false);
            }
        }){

            public void func_230431_b_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
                ItemStack bookStack = ((InfuserContainer)InfuserScreen.this.field_147002_h).getTile().getBookInSlot();
                if (!bookStack.func_190926_b()) {
                    Minecraft minecraft = Minecraft.func_71410_x();
                    minecraft.func_110434_K().func_110577_a(InfuserScreen.this.TEXTURE);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    this.func_238474_b_(ms, this.field_230690_l_, this.field_230691_m_, 201, 0, btnSize, btnSize);
                    this.func_230441_a_(ms, minecraft, mouseX, mouseY);
                }
            }
        });
        x = 39;
        y = 101;
        this.buttonInfuse = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + x, this.field_147009_r + y, btnSize, btnSize, (ITextComponent)new TranslationTextComponent(""), button -> {
            ItemStack bookStack = ((InfuserContainer)this.field_147002_h).getTile().getBookInSlot();
            if (bookStack.func_190926_b()) {
                this.field_213127_e.field_70458_d.func_146105_b((ITextComponent)new TranslationTextComponent("gui.forcecraft.infuser.nobook"), false);
            } else {
                PacketHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new InfuserMessage(true));
            }
        }){

            public void func_230431_b_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
                boolean flag;
                boolean bl = flag = ((InfuserContainer)InfuserScreen.this.func_212873_a_()).validRecipe[0] == 1;
                if (flag) {
                    Minecraft minecraft = Minecraft.func_71410_x();
                    minecraft.func_110434_K().func_110577_a(InfuserScreen.this.TEXTURE);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    this.func_238474_b_(ms, this.field_230690_l_, this.field_230691_m_, 188, 0, btnSize, btnSize);
                    this.func_230441_a_(ms, minecraft, mouseX, mouseY);
                }
            }
        });
    }

    public void func_231023_e_() {
        boolean flag;
        super.func_231023_e_();
        boolean bl = flag = ((InfuserContainer)this.func_212873_a_()).validRecipe[0] == 1;
        if (this.buttonInfuse.field_230693_o_ != flag) {
            this.buttonInfuse.field_230693_o_ = flag;
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        this.field_230706_i_.func_110434_K().func_110577_a(this.TEXTURE);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawFluidBar(matrixStack);
        this.drawEnergyBar(matrixStack);
        this.drawProgressBar(matrixStack);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        ArrayList<Object> text;
        int actualMouseX = mouseX - (this.field_230708_k_ - this.field_146999_f) / 2;
        int actualMouseY = mouseY - (this.field_230709_l_ - this.field_147000_g) / 2;
        InfuserTileEntity tile = ((InfuserContainer)this.field_147002_h).getTile();
        if (this.func_195359_a(123, 16, 12, 12, mouseX, mouseY) && tile.handler.getStackInSlot(9).func_190926_b()) {
            text = new ArrayList<Object>();
            text.add(new TranslationTextComponent("gui.forcecraft.infuser.help.tooltip").func_240699_a_(TextFormatting.GRAY));
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, text, (int)actualMouseX, (int)actualMouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
        }
        if (this.func_195359_a(39, 101, 12, 12, mouseX, mouseY)) {
            text = new ArrayList();
            if (((InfuserContainer)this.func_212873_a_()).isWorkAllowed()) {
                text.add(new TranslationTextComponent("gui.forcecraft.infuser.start.tooltip").func_240699_a_(TextFormatting.GRAY));
            } else {
                boolean modifiersEmpty = tile.areAllModifiersEmpty();
                if (!modifiersEmpty && tile.getEnergyStored() < tile.getEnergyCostPer()) {
                    text.add(new TranslationTextComponent("gui.forcecraft.infuser.missing.rf.tooltip").func_240699_a_(TextFormatting.RED));
                } else {
                    text.add(new TranslationTextComponent("gui.forcecraft.infuser.missing.tooltip").func_240699_a_(TextFormatting.RED));
                }
            }
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, text, (int)actualMouseX, (int)actualMouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
        }
        if (this.func_195359_a(156, 8, 12, 112, mouseX, mouseY)) {
            text = new ArrayList();
            IFormattableTextComponent tt = new StringTextComponent(tile.getEnergyStored() + " RF").func_240699_a_(TextFormatting.GOLD);
            text.add(tt);
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, text, (int)actualMouseX, (int)actualMouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
        }
        if (this.func_195359_a(10, 41, 15, 82, mouseX, mouseY)) {
            text = new ArrayList();
            if (tile.getFluid() == null) {
                text.add(new TranslationTextComponent("gui.forcecraft.infuser.empty.tooltip"));
            } else {
                text.add(new TranslationTextComponent("fluid.forcecraft.fluid_force_source"));
                text.add(new StringTextComponent(tile.getFluidAmount() + " mb").func_240699_a_(TextFormatting.YELLOW));
            }
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, text, (int)actualMouseX, (int)actualMouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
        }
    }

    private void drawFluidBar(MatrixStack matrixStack) {
        if (((InfuserContainer)this.field_147002_h).getTile() == null || ((InfuserContainer)this.field_147002_h).getTile().getFluid() == null) {
            return;
        }
        FluidStack fluidStack = ((InfuserContainer)this.field_147002_h).getTile().getFluidStack();
        float tankPercentage = RenderHelper.getTankPercentage(((InfuserContainer)this.func_212873_a_()).getTile().getFluidAmount(), 50000);
        RenderHelper.drawFluidTankInGUI(fluidStack, this.field_147003_i + 8, this.field_147009_r + 41, tankPercentage, 82);
        this.field_230706_i_.field_71446_o.func_110577_a(this.TEXTURE);
        this.func_238474_b_(matrixStack, this.field_147003_i + 8, this.field_147009_r + 41, 188, 26, 16, 82);
    }

    private void drawEnergyBar(MatrixStack ms) {
        if (((InfuserContainer)this.field_147002_h).getTile() == null || ((InfuserContainer)this.field_147002_h).getTile().energyStorage.getMaxEnergyStored() <= 0) {
            return;
        }
        this.field_230706_i_.field_71446_o.func_110577_a(this.ENERGY);
        float energ = ((InfuserContainer)this.func_212873_a_()).getTile().getEnergyStored();
        float capacity = ((InfuserContainer)this.field_147002_h).getTile().energyStorage.getMaxEnergyStored();
        float pct = Math.min(energ / capacity, 1.0f);
        float height = 107.0f;
        int width = 12;
        InfuserScreen.func_238463_a_((MatrixStack)ms, (int)(this.field_147003_i + 156), (int)(this.field_147009_r + 13), (float)0.0f, (float)0.0f, (int)width, (int)((int)(107.0f * pct)), (int)width, (int)107);
    }

    private void drawProgressBar(MatrixStack matrixStack) {
        InfuserTileEntity tile = ((InfuserContainer)this.field_147002_h).getTile();
        if (tile.canWork) {
            this.infuserProgress.setMin(tile.processTime).setMax(tile.maxProcessTime);
            this.infuserProgress.draw(matrixStack, this.field_230706_i_);
        }
    }
}

