/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blocks.infuser;

import com.mrbysco.forcecraft.ForceCraft;
import com.mrbysco.forcecraft.blocks.infuser.InfuserTileEntity;
import com.mrbysco.forcecraft.capablilities.CapabilityHandler;
import com.mrbysco.forcecraft.capablilities.forcerod.IForceRodModifier;
import com.mrbysco.forcecraft.capablilities.toolmodifier.IToolModifier;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.items.ForceArmorItem;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookData;
import com.mrbysco.forcecraft.items.tools.ForceAxeItem;
import com.mrbysco.forcecraft.items.tools.ForceBowItem;
import com.mrbysco.forcecraft.items.tools.ForcePickaxeItem;
import com.mrbysco.forcecraft.items.tools.ForceRodItem;
import com.mrbysco.forcecraft.items.tools.ForceShovelItem;
import com.mrbysco.forcecraft.items.tools.ForceSwordItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum InfuserModifierType {
    SPEED,
    HEAT,
    FORCE,
    SILK,
    DAMAGE,
    FORTUNE,
    LIGHT,
    STURDY,
    LUMBERJACK,
    HEALING,
    ENDER,
    BLEEDING,
    BANE,
    WING,
    CAMO,
    RAINBOW,
    TIME,
    PACK1,
    PACK2,
    PACK3,
    PACK4,
    GRINDING,
    FREEZING,
    EXP,
    STORAGE,
    SIGHT,
    TREASURE,
    ITEM;


    public boolean apply(ItemStack tool, ItemStack mod, UpgradeBookData bd) {
        switch (this) {
            case DAMAGE: {
                return InfuserTileEntity.addDamageModifier(tool);
            }
            case ENDER: {
                return InfuserTileEntity.addEnderModifier(tool);
            }
            case FORCE: {
                return InfuserTileEntity.addForceModifier(tool);
            }
            case HEALING: {
                return InfuserTileEntity.addHealingModifier(tool);
            }
            case HEAT: {
                return InfuserTileEntity.addHeatModifier(tool);
            }
            case LIGHT: {
                return InfuserTileEntity.addLightModifier(tool);
            }
            case FORTUNE: {
                return InfuserTileEntity.addLuckModifier(tool);
            }
            case LUMBERJACK: {
                return InfuserTileEntity.addLumberjackModifier(tool);
            }
            case SILK: {
                return InfuserTileEntity.addSilkTouchModifier(tool);
            }
            case SPEED: {
                return InfuserTileEntity.addSpeedModifier(tool);
            }
            case STURDY: {
                return InfuserTileEntity.addSturdyModifier(tool);
            }
            case CAMO: {
                return InfuserTileEntity.applyCamo(tool, mod);
            }
            case BANE: {
                return InfuserTileEntity.addBaneModifier(tool);
            }
            case BLEEDING: {
                return InfuserTileEntity.addBleedingModifier(tool);
            }
            case WING: {
                return InfuserTileEntity.addWingModifier(tool);
            }
            case RAINBOW: {
                return InfuserTileEntity.addRainbowModifier(tool);
            }
            case TIME: {
                break;
            }
            case TREASURE: {
                return InfuserTileEntity.addTreasureModifier(tool);
            }
            case PACK1: 
            case PACK2: 
            case PACK3: 
            case PACK4: {
                return InfuserTileEntity.upgradeBag(tool, bd);
            }
            case ITEM: {
                return true;
            }
            case EXP: {
                break;
            }
            case FREEZING: {
                return InfuserTileEntity.addFreezingModifier(tool);
            }
            case GRINDING: {
                break;
            }
            case SIGHT: {
                break;
            }
        }
        ForceCraft.LOGGER.error("Error: No action for modifier {}", (Object)this);
        return false;
    }

    public int getLevelCap(ItemStack centerStack) {
        Item item = centerStack.func_77973_b();
        switch (this) {
            case DAMAGE: {
                IToolModifier modifierCap;
                if (item instanceof ForceSwordItem || item instanceof ForceBowItem) {
                    IToolModifier modifierCap2 = (IToolModifier)centerStack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
                    if (modifierCap2 == null) break;
                    return (Integer)ConfigHandler.COMMON.damageCap.get();
                }
                if (!(item instanceof ForceArmorItem) || (modifierCap = (IToolModifier)centerStack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) == null) break;
                return 1;
            }
            case ENDER: 
            case HEAT: 
            case LIGHT: 
            case LUMBERJACK: 
            case SILK: 
            case CAMO: 
            case BANE: 
            case WING: 
            case RAINBOW: 
            case TREASURE: 
            case PACK1: 
            case PACK2: 
            case PACK3: 
            case PACK4: 
            case ITEM: 
            case EXP: 
            case FREEZING: 
            case GRINDING: 
            case SIGHT: 
            case STORAGE: {
                return 1;
            }
            case FORCE: {
                IToolModifier modifierCap;
                if (!(item instanceof ForceSwordItem) && !(item instanceof ForceAxeItem) || (modifierCap = (IToolModifier)centerStack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) == null) break;
                return (Integer)ConfigHandler.COMMON.forceCap.get();
            }
            case HEALING: {
                IForceRodModifier rodCap;
                if (!(item instanceof ForceRodItem) || (rodCap = (IForceRodModifier)centerStack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).orElse(null)) == null) break;
                return (Integer)ConfigHandler.COMMON.healingCap.get();
            }
            case FORTUNE: {
                return (Integer)ConfigHandler.COMMON.luckCap.get();
            }
            case SPEED: {
                IForceRodModifier rodCap;
                if (item instanceof ForceShovelItem || item instanceof ForcePickaxeItem || item instanceof ForceAxeItem) {
                    IToolModifier modifierCap = (IToolModifier)centerStack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
                    if (modifierCap == null) break;
                    return (Integer)ConfigHandler.COMMON.speedCap.get();
                }
                if (item instanceof ForceBowItem) {
                    IToolModifier modifierCap = (IToolModifier)centerStack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
                    if (modifierCap == null) break;
                    return 1;
                }
                if (item instanceof ForceArmorItem) {
                    IToolModifier modifierCap = (IToolModifier)centerStack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
                    if (modifierCap == null) break;
                    return 1;
                }
                if (!(item instanceof ForceRodItem) || (rodCap = (IForceRodModifier)centerStack.getCapability(CapabilityHandler.CAPABILITY_FORCEROD).orElse(null)) == null) break;
                return (Integer)ConfigHandler.COMMON.rodSpeedCap.get();
            }
            case STURDY: {
                IToolModifier modifierCap;
                if (item instanceof ForceSwordItem || item instanceof ForceAxeItem || item instanceof ForceShovelItem || item instanceof ForcePickaxeItem || item instanceof ForceRodItem) {
                    IToolModifier modifierCap3 = (IToolModifier)centerStack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
                    if (modifierCap3 == null) break;
                    return (Integer)ConfigHandler.COMMON.sturdyToolCap.get();
                }
                if (!(item instanceof ForceArmorItem) || (modifierCap = (IToolModifier)centerStack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) == null) break;
                return 1;
            }
            case BLEEDING: {
                IToolModifier modifierCap;
                if (!(item instanceof ForceSwordItem) && !(item instanceof ForceBowItem) && !(item instanceof ForceArmorItem) || (modifierCap = (IToolModifier)centerStack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) == null) break;
                return (Integer)ConfigHandler.COMMON.bleedCap.get();
            }
            case TIME: {
                if (!((Boolean)ConfigHandler.COMMON.timeTorchEnabled.get()).booleanValue()) break;
                return 1;
            }
        }
        return 0;
    }

    public String getTooltip() {
        return "gui.forcecraft.infuser.tooltip." + this.name().toLowerCase();
    }
}

