/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blocks.infuser;

import com.mrbysco.forcecraft.blocks.infuser.InfuserTileEntity;
import com.mrbysco.forcecraft.container.slot.SlotForceGems;
import com.mrbysco.forcecraft.registry.ForceContainers;
import com.mrbysco.forcecraft.util.AdvancementUtil;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IntReferenceHolder;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class InfuserContainer
extends Container {
    private InfuserTileEntity tile;
    private PlayerEntity player;
    public final int[] validRecipe = new int[1];

    public InfuserContainer(int windowId, PlayerInventory playerInventory, PacketBuffer data) {
        this(windowId, playerInventory, InfuserContainer.getTileEntity(playerInventory, data));
    }

    private static InfuserTileEntity getTileEntity(PlayerInventory playerInventory, PacketBuffer data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        TileEntity tileAtPos = playerInventory.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        if (tileAtPos instanceof InfuserTileEntity) {
            return (InfuserTileEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public InfuserContainer(int id, PlayerInventory playerInventoryIn, InfuserTileEntity te) {
        super((ContainerType)ForceContainers.INFUSER.get(), id);
        this.tile = te;
        this.player = playerInventoryIn.field_70458_d;
        this.func_75146_a((Slot)new UnlockableSlot((IItemHandler)te.handler, 0, 80, 20));
        this.func_75146_a((Slot)new UnlockableSlot((IItemHandler)te.handler, 1, 104, 32));
        this.func_75146_a((Slot)new UnlockableSlot((IItemHandler)te.handler, 2, 116, 57));
        this.func_75146_a((Slot)new UnlockableSlot((IItemHandler)te.handler, 3, 104, 81));
        this.func_75146_a((Slot)new UnlockableSlot((IItemHandler)te.handler, 4, 80, 93));
        this.func_75146_a((Slot)new UnlockableSlot((IItemHandler)te.handler, 5, 56, 81));
        this.func_75146_a((Slot)new UnlockableSlot((IItemHandler)te.handler, 6, 44, 57));
        this.func_75146_a((Slot)new UnlockableSlot((IItemHandler)te.handler, 7, 56, 32));
        this.func_75146_a((Slot)new MatrixUpdatingSlot((IItemHandler)te.handler, 8, 80, 57));
        this.func_75146_a((Slot)new SlotForceGems((IItemHandler)te.handler, 9, 8, 23));
        this.func_75146_a((Slot)new MatrixUpdatingSlot((IItemHandler)te.handler, 10, 8, 5));
        int xPos = 8;
        int yPos = 127;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInventoryIn, x + y * 9 + 9, xPos + x * 18, yPos + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInventoryIn, x, xPos + x * 18, yPos + 58));
        }
        this.trackPower();
        this.trackFluid();
        this.validRecipe[0] = this.tile.hasValidRecipe() ? 1 : 0;
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.validRecipe, (int)0));
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return ((InfuserContainer)InfuserContainer.this).tile.processTime;
            }

            public void func_221494_a(int value) {
                ((InfuserContainer)InfuserContainer.this).tile.processTime = value;
            }
        });
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return ((InfuserContainer)InfuserContainer.this).tile.maxProcessTime;
            }

            public void func_221494_a(int value) {
                ((InfuserContainer)InfuserContainer.this).tile.maxProcessTime = value;
            }
        });
        AdvancementUtil.unlockTierAdvancements(this.player, this.tile.getBookTier());
    }

    private void trackFluid() {
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return InfuserContainer.this.tile.getFluidAmount() & 0xFFFF;
            }

            public void func_221494_a(int value) {
                int fluidStored = InfuserContainer.this.tile.getFluidAmount() & 0xFFFF0000;
                InfuserContainer.this.tile.setFluidAmount(fluidStored + (value & 0xFFFF));
            }
        });
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return InfuserContainer.this.tile.getFluidAmount() >> 16 & 0xFFFF;
            }

            public void func_221494_a(int value) {
                int fluidStored = InfuserContainer.this.tile.getFluidAmount() & 0xFFFF;
                InfuserContainer.this.tile.setFluidAmount(fluidStored | value << 16);
            }
        });
    }

    private void trackPower() {
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return InfuserContainer.this.tile.getEnergyStored() & 0xFFFF;
            }

            public void func_221494_a(int value) {
                int energyStored = InfuserContainer.this.tile.getEnergyStored() & 0xFFFF0000;
                InfuserContainer.this.tile.setEnergyStored(energyStored + (value & 0xFFFF));
            }
        });
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return InfuserContainer.this.tile.getEnergyStored() >> 16 & 0xFFFF;
            }

            public void func_221494_a(int value) {
                int energyStored = InfuserContainer.this.tile.getEnergyStored() & 0xFFFF;
                InfuserContainer.this.tile.setEnergyStored(energyStored | value << 16);
            }
        });
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.tile.func_70300_a(playerIn) && !playerIn.func_175149_v();
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            int tileSize = 11;
            if (index < 11 ? !this.func_75135_a(itemstack1, 11, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, 11, true)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        this.func_75130_a(null);
        return itemstack;
    }

    public boolean isWorkAllowed() {
        return this.tile.isWorkAllowed();
    }

    public InfuserTileEntity getTile() {
        return this.tile;
    }

    public void func_75142_b() {
        super.func_75142_b();
    }

    public void func_75130_a(IInventory inventoryIn) {
        if (inventoryIn != null) {
            super.func_75130_a(inventoryIn);
        }
        if (!this.player.field_70170_p.field_72995_K) {
            this.validRecipe[0] = this.tile.updateValidRecipe() ? 1 : 0;
        }
        AdvancementUtil.unlockTierAdvancements(this.player, this.tile.getBookTier());
    }

    public class UnlockableSlot
    extends MatrixUpdatingSlot {
        private final int index;

        public UnlockableSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
            this.index = index;
        }

        public boolean func_111238_b() {
            return this.index <= InfuserContainer.this.tile.getBookTier();
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return this.index <= InfuserContainer.this.tile.getBookTier() && super.func_75214_a(stack);
        }

        @Override
        public int func_75219_a() {
            return 1;
        }
    }

    public class MatrixUpdatingSlot
    extends SlotItemHandler {
        public MatrixUpdatingSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public void func_75218_e() {
            super.func_75218_e();
            InfuserContainer.this.func_75130_a(null);
        }

        public int func_75219_a() {
            return 1;
        }
    }
}

