/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blocks.infuser;

import com.mrbysco.forcecraft.blocks.infuser.InfuserTileEntity;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;

public class InfuserBlock
extends Block {
    private static final VoxelShape SHAPE = Stream.of(Block.func_208617_a((double)3.0, (double)10.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)5.0, (double)4.0), Block.func_208617_a((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)5.0, (double)4.0), Block.func_208617_a((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)5.0, (double)14.0), Block.func_208617_a((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)5.0, (double)14.0), Block.func_208617_a((double)2.0, (double)5.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    public InfuserBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new InfuserTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof InfuserTileEntity) {
            LazyOptional fluidHandler = tileentity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, hit.func_216354_b());
            fluidHandler.ifPresent(handler -> {
                if (playerIn.func_184586_b(handIn).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
                    FluidUtil.interactWithFluidHandler((PlayerEntity)playerIn, (Hand)handIn, (World)worldIn, (BlockPos)pos, (Direction)hit.func_216354_b());
                } else if (!worldIn.field_72995_K) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)((InfuserTileEntity)tileentity), (BlockPos)pos);
                }
            });
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof InfuserTileEntity) {
                tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)handler.getStackInSlot(i));
                    }
                });
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof InfuserTileEntity) {
            InfuserTileEntity infuserTile = (InfuserTileEntity)tileentity;
            if (infuserTile.processTime > 0) {
                double d0 = (double)pos.func_177958_n() + 0.5;
                double d1 = (double)pos.func_177956_o() + 0.5;
                double d2 = (double)pos.func_177952_p() + 0.5;
                Direction direction = Direction.UP;
                Direction.Axis direction$axis = direction.func_176740_k();
                for (int i = 0; i < 3; ++i) {
                    double d3 = 0.52;
                    double d4 = rand.nextDouble() * 0.6 - 0.3;
                    double d5 = direction$axis == Direction.Axis.X ? (double)direction.func_82601_c() * d3 : d4;
                    double d6 = rand.nextDouble() * 6.0 / 16.0;
                    double d7 = direction$axis == Direction.Axis.Z ? (double)direction.func_82599_e() * d3 : d4;
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_239819_as_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

