/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blocks.engine;

import com.mrbysco.forcecraft.tiles.ForceEngineTile;
import java.util.Random;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;

public class ForceEngineBlock
extends DirectionalBlock {
    public static final VoxelShape SHAPE_UP = Stream.of(Block.func_208617_a((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.func_208617_a((double)11.0, (double)4.0, (double)3.0, (double)15.0, (double)11.0, (double)13.0), Block.func_208617_a((double)1.0, (double)4.0, (double)3.0, (double)5.0, (double)11.0, (double)13.0), Block.func_208617_a((double)3.0, (double)4.0, (double)12.0, (double)13.0, (double)10.0, (double)14.0), Block.func_208617_a((double)3.0, (double)4.0, (double)2.0, (double)13.0, (double)10.0, (double)4.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    public static final VoxelShape SHAPE_DOWN = Stream.of(Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), Block.func_208617_a((double)11.0, (double)5.0, (double)3.0, (double)15.0, (double)12.0, (double)13.0), Block.func_208617_a((double)1.0, (double)5.0, (double)3.0, (double)5.0, (double)12.0, (double)13.0), Block.func_208617_a((double)3.0, (double)6.0, (double)2.0, (double)13.0, (double)12.0, (double)4.0), Block.func_208617_a((double)3.0, (double)6.0, (double)12.0, (double)13.0, (double)12.0, (double)14.0), Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    public static final VoxelShape SHAPE_NORTH = Stream.of(Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0), Block.func_208617_a((double)11.0, (double)3.0, (double)5.0, (double)15.0, (double)13.0, (double)12.0), Block.func_208617_a((double)1.0, (double)3.0, (double)5.0, (double)5.0, (double)13.0, (double)12.0), Block.func_208617_a((double)3.0, (double)12.0, (double)6.0, (double)13.0, (double)14.0, (double)12.0), Block.func_208617_a((double)3.0, (double)2.0, (double)6.0, (double)13.0, (double)4.0, (double)12.0), Block.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    public static final VoxelShape SHAPE_EAST = Stream.of(Block.func_208617_a((double)8.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), Block.func_208617_a((double)4.0, (double)3.0, (double)11.0, (double)11.0, (double)13.0, (double)15.0), Block.func_208617_a((double)4.0, (double)3.0, (double)1.0, (double)11.0, (double)13.0, (double)5.0), Block.func_208617_a((double)4.0, (double)12.0, (double)3.0, (double)10.0, (double)14.0, (double)13.0), Block.func_208617_a((double)4.0, (double)2.0, (double)3.0, (double)10.0, (double)4.0, (double)13.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    public static final VoxelShape SHAPE_SOUTH = Stream.of(Block.func_208617_a((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0), Block.func_208617_a((double)11.0, (double)3.0, (double)4.0, (double)15.0, (double)13.0, (double)11.0), Block.func_208617_a((double)1.0, (double)3.0, (double)4.0, (double)5.0, (double)13.0, (double)11.0), Block.func_208617_a((double)3.0, (double)2.0, (double)4.0, (double)13.0, (double)4.0, (double)10.0), Block.func_208617_a((double)3.0, (double)12.0, (double)4.0, (double)13.0, (double)14.0, (double)10.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    public static final VoxelShape SHAPE_WEST = Stream.of(Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0), Block.func_208617_a((double)5.0, (double)3.0, (double)11.0, (double)12.0, (double)13.0, (double)15.0), Block.func_208617_a((double)5.0, (double)3.0, (double)1.0, (double)12.0, (double)13.0, (double)5.0), Block.func_208617_a((double)6.0, (double)2.0, (double)3.0, (double)12.0, (double)4.0, (double)13.0), Block.func_208617_a((double)6.0, (double)12.0, (double)3.0, (double)12.0, (double)14.0, (double)13.0), Block.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");

    public ForceEngineBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176387_N, (Comparable)Direction.UP)).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof ForceEngineTile) {
            LazyOptional fluidHandler = tileentity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, hit.func_216354_b());
            fluidHandler.ifPresent(handler -> {
                if (player.func_184586_b(handIn).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
                    FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)handIn, (World)worldIn, (BlockPos)pos, (Direction)hit.func_216354_b());
                } else if (!worldIn.field_72995_K) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((ForceEngineTile)tileentity), (BlockPos)pos);
                }
            });
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)field_176387_N)) {
            case UP: {
                return SHAPE_UP;
            }
            case DOWN: {
                return SHAPE_DOWN;
            }
            case NORTH: {
                return SHAPE_NORTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return super.func_220053_a(state, worldIn, pos, context);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_176387_N, ACTIVE});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)field_176387_N, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)field_176387_N)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.func_206870_a((Property)field_176387_N, (Comparable)mirrorIn.func_185803_b((Direction)state.func_177229_b((Property)field_176387_N)));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(direction.func_176734_d()));
        return blockstate.func_203425_a((Block)this) && blockstate.func_177229_b((Property)field_176387_N) == direction ? (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_176387_N, (Comparable)direction)).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a()))) : (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_176387_N, (Comparable)direction.func_176734_d())).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a())));
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!worldIn.field_72995_K && (flag = ((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue()) != worldIn.func_175640_z(pos)) {
            if (flag) {
                worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 4);
            } else {
                worldIn.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)ACTIVE), 2);
            }
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((Property)ACTIVE)).booleanValue() && !worldIn.func_175640_z(pos)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)ACTIVE), 2);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ForceEngineTile();
    }

    public static ToIntFunction<BlockState> getLightValueActive(int lightValue) {
        return state -> (Boolean)state.func_177229_b((Property)ACTIVE) != false ? lightValue : 0;
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((Property)ACTIVE)).booleanValue()) {
            Direction direction = (Direction)stateIn.func_177229_b((Property)field_176387_N);
            double d0 = (double)pos.func_177958_n() + 0.55 - (double)(rand.nextFloat() * 0.1f);
            double d1 = (double)pos.func_177956_o() + 0.55 - (double)(rand.nextFloat() * 0.1f);
            double d2 = (double)pos.func_177952_p() + 0.55 - (double)(rand.nextFloat() * 0.1f);
            double d3 = 0.4f - (rand.nextFloat() + rand.nextFloat()) * 0.4f;
            if (rand.nextInt(5) == 0) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + (double)direction.func_82601_c() * d3, d1 + (double)direction.func_96559_d() * d3, d2 + (double)direction.func_82599_e() * d3, rand.nextGaussian() * 0.005, rand.nextGaussian() * 0.005, rand.nextGaussian() * 0.005);
            }
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof ForceEngineTile) {
                ForceEngineTile engineTile = (ForceEngineTile)tileentity;
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)engineTile.inputHandler.getStackInSlot(0));
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)engineTile.inputHandler.getStackInSlot(1));
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)engineTile.outputHandler.getStackInSlot(0));
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)engineTile.outputHandler.getStackInSlot(1));
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }
}

