/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blocks;

import com.mrbysco.forcecraft.items.UpgradeCoreItem;
import com.mrbysco.forcecraft.tiles.AbstractForceFurnaceTile;
import com.mrbysco.forcecraft.tiles.ForceFurnaceTileEntity;
import java.util.Random;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class ForceFurnaceBlock
extends AbstractFurnaceBlock {
    private static final String NBT_UPGRADE = "upgrade";

    public ForceFurnaceBlock(AbstractBlock.Properties builder) {
        super(builder);
    }

    public static ToIntFunction<BlockState> getLightValueLit(int lightValue) {
        return state -> (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) != false ? lightValue : 0;
    }

    protected void func_220089_a(World worldIn, BlockPos pos, PlayerEntity player) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof ForceFurnaceTileEntity) {
            if (!worldIn.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((ForceFurnaceTileEntity)tileentity), (BlockPos)pos);
            }
            player.func_195066_a(Stats.field_188061_aa);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((Property)field_220091_b)).booleanValue()) {
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = pos.func_177956_o();
            double d2 = (double)pos.func_177952_p() + 0.5;
            if (rand.nextDouble() < 0.1) {
                worldIn.func_184134_a(d0, d1, d2, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)stateIn.func_177229_b((Property)field_220090_a);
            Direction.Axis direction$axis = direction.func_176740_k();
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.func_82601_c() * d3 : d4;
            double d6 = rand.nextDouble() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.func_82599_e() * d3 : d4;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new ForceFurnaceTileEntity();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof AbstractForceFurnaceTile) {
                AbstractForceFurnaceTile furnaceTile = (AbstractForceFurnaceTile)tileentity;
                for (int i = 0; i < furnaceTile.func_70302_i_(); ++i) {
                    if (furnaceTile.func_70301_a(i).func_77973_b() instanceof UpgradeCoreItem) continue;
                    ForceFurnaceBlock.spawnItemStack(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), furnaceTile.func_70301_a(i));
                }
                ((AbstractForceFurnaceTile)tileentity).grantStoredRecipeExperience(worldIn, Vector3d.func_237489_a_((Vector3i)pos));
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public static void spawnItemStack(World worldIn, double x, double y, double z, ItemStack stack) {
        double d0 = EntityType.field_200765_E.func_220333_h();
        double d1 = 1.0 - d0;
        double d2 = d0 / 2.0;
        double d3 = Math.floor(x) + worldIn.field_73012_v.nextDouble() * d1 + d2;
        double d4 = Math.floor(y) + worldIn.field_73012_v.nextDouble() * d1;
        double d5 = Math.floor(z) + worldIn.field_73012_v.nextDouble() * d1 + d2;
        while (!stack.func_190926_b()) {
            ItemEntity itementity = new ItemEntity(worldIn, d3, d4, d5, stack.func_77979_a(worldIn.field_73012_v.nextInt(21) + 10));
            float f = 0.05f;
            itementity.func_213293_j(worldIn.field_73012_v.nextGaussian() * (double)0.05f, worldIn.field_73012_v.nextGaussian() * (double)f + (double)0.2f, worldIn.field_73012_v.nextGaussian() * (double)f);
            worldIn.func_217376_c((Entity)itementity);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof AbstractForceFurnaceTile) {
            AbstractForceFurnaceTile furnaceTile = (AbstractForceFurnaceTile)tileentity;
            if (stack.func_82837_s()) {
                furnaceTile.func_213903_a(stack.func_200301_q());
            }
            if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(NBT_UPGRADE)) {
                ItemStack upgrade = ItemStack.func_199557_a((CompoundNBT)stack.func_77978_p().func_74775_l(NBT_UPGRADE));
                furnaceTile.setUpgrade(upgrade);
            }
        }
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        ForceFurnaceTileEntity tile;
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        if (te instanceof ForceFurnaceTileEntity && !(tile = (ForceFurnaceTileEntity)te).getUpgrade().func_190926_b()) {
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 0.5f, 1.0f);
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }
}

